# 🚀 BayarCash Module - Quick Start Guide

## 📋 What You Need Before Starting

1. **BayarCash Merchant Account**
   - Portal Key
   - PAT Key
   - API Token
   - API Secret Key

2. **Server Access**
   - SSH/Terminal access OR hosting panel with terminal
   - PHP 8.1+ with Composer

## ⚡ 5-Minute Setup

### Step 1: Upload Module (2 minutes)
```bash
# Extract BayarCash-Production-Deploy.tar.gz
# Upload the BayarCash folder to: your-website/Modules/BayarCash/
```

### Step 2: Install Dependencies (1 minute)
```bash
cd /path/to/your/website
composer require webimpian/bayarcash-php-sdk:^2.0
```

### Step 3: Activate Module (1 minute)
```bash
php artisan module:activate BayarCash
php artisan migrate
```

### Step 4: Configure Settings (1 minute)
Add to `.env`:
```env
BAYARCASH_API_TOKEN=your_token
BAYARCASH_API_SECRET_KEY=your_secret
```

Go to: **Admin Panel → Settings → Payment → BayarCash**
- Enter Portal Key and PAT Key
- Set Sandbox to `false`
- Enable the gateway

## ✅ Verification
- Check: `php artisan module:list` shows BayarCash as Active
- Check: Admin settings page loads without errors
- Check: Payment options appear in checkout

## 🆘 If Something Goes Wrong

**Module won't activate?**
```bash
# Edit Modules/BayarCash/module.json
# Change "require": {"webimpian/bayarcash-php-sdk": "^2.0"} to "require": {}
php artisan module:activate BayarCash
# Then restore the original require block
```

**Routes not working?**
```bash
php artisan route:clear
php artisan config:clear
php artisan route:cache
```

**Need help?** Check the full DEPLOYMENT-INSTRUCTIONS.md for detailed troubleshooting.

---
**🎉 You're done! BayarCash is now ready to accept payments.**