<?php

use Illuminate\Support\Facades\Route;
use Modules\BayarCash\Http\Controllers\BayarCashController;

/*
|--------------------------------------------------------------------------
| BayarCash Payment Gateway Routes
|--------------------------------------------------------------------------
|
| These routes handle BayarCash payment processing for tenant payment flows.
| All routes are secured with tenant middleware and include proper subdomain handling.
|
*/

Route::middleware(['web', 'tenant'])->group(function () {
    Route::prefix('{subdomain}/payment/bayarcash')->group(function () {
        // Payment checkout route
        Route::get('/checkout/{invoice}', [BayarCashController::class, 'checkout'])
            ->name('tenant.payment.bayarcash.checkout')
            ->where('invoice', '[0-9]+');

        // Payment return route (customer redirect after payment)
        Route::get('/return/{invoice}', [BayarCashController::class, 'returnUrl'])
            ->name('tenant.payment.bayarcash.return')
            ->where('invoice', '[0-9]+');

        // Webhook callback route (server-to-server)
        Route::post('/callback', [BayarCashController::class, 'callback'])
            ->name('tenant.payment.bayarcash.callback')
            ->middleware('throttle:100,1'); // Allow high frequency webhooks

        // Webhook route (alternative endpoint)
        Route::post('/webhook', [BayarCashController::class, 'webhook'])
            ->name('tenant.payment.bayarcash.webhook')
            ->middleware('throttle:100,1'); // Allow high frequency webhooks
    });
});