<?php

namespace Modules\BayarCash\Listeners;

use App\Events\PaymentGatewayRegistration;
use App\Settings\PaymentSettings;
use Modules\BayarCash\Services\BayarCashPaymentGateway;

class RegisterBayarCashPaymentGateway
{
    /**
     * Handle the event.
     */
    public function handle(PaymentGatewayRegistration $event): void
    {
        $settings = app(PaymentSettings::class);

        // Register BayarCash only if enabled and configured
        if ($settings->bayarcash_enabled &&
            !empty($settings->bayarcash_portal_key) &&
            !empty($settings->bayarcash_pat_key) &&
            !empty($settings->bayarcash_api_secret_key)) {

            $event->billingManager->register('bayarcash', function () use ($settings) {
                return app(BayarCashPaymentGateway::class);
            });
        }
    }
}