# BayarCash Payment Gateway - Installation Guide

This guide provides step-by-step instructions for installing and configuring the BayarCash Payment Gateway module.

## 📋 Prerequisites

Before installing the BayarCash module, ensure you have:

1. **Laravel Application**: Laravel 10.0+ or 11.0+
2. **PHP Version**: PHP 8.1 or higher
3. **BayarCash Account**: Active merchant account with BayarCash
4. **Database**: MySQL or PostgreSQL
5. **Composer**: Latest version installed

## 🔐 BayarCash Account Setup

### 1. Create BayarCash Account

1. Visit [BayarCash](https://bayarcash.com)
2. Sign up for a merchant account
3. Complete the verification process
4. Submit required documentation

### 2. Obtain API Credentials

Once your account is approved:

1. Log into your BayarCash dashboard
2. Navigate to **Settings** > **API Keys**
3. Generate and note down:
   - **Portal Key**: Your unique portal identifier
   - **Personal Access Token (PAT)**: For API authentication
   - **API Secret Key**: For webhook signature validation

### 3. Configure Webhooks

In your BayarCash dashboard:

1. Go to **Settings** > **Webhooks**
2. Add webhook endpoints:
   ```
   Production: https://yourdomain.com/{subdomain}/payment/bayarcash/webhook
   Staging: https://staging.yourdomain.com/{subdomain}/payment/bayarcash/webhook
   ```
3. Enable webhook events:
   - Payment Completed
   - Payment Failed
   - Payment Pending

## 🛠 Module Installation

### Method 1: Manual Installation (Recommended)

1. **Copy Module Files**
   ```bash
   # Copy the BayarCash module to your Modules directory
   cp -r /path/to/BayarCash Modules/
   ```

2. **Install Dependencies**
   ```bash
   # Install BayarCash PHP SDK
   composer require webimpian/bayarcash-php-sdk:^2.0
   ```

3. **Clear Application Cache**
   ```bash
   php artisan cache:clear
   php artisan config:clear
   php artisan route:clear
   ```

### Method 2: Composer Installation

```bash
# If the module is published to a package repository
composer require modules/bayarcash
```

## ⚙️ Configuration

### 1. Environment Variables

Add these variables to your `.env` file:

```env
# BayarCash Configuration
BAYARCASH_PORTAL_KEY=your_portal_key_here
BAYARCASH_PAT_KEY=your_pat_key_here
BAYARCASH_SECRET_KEY=your_secret_key_here
BAYARCASH_SANDBOX=true
BAYARCASH_ENABLED=true
```

**Important**:
- Set `BAYARCASH_SANDBOX=false` for production
- Keep your secret keys secure and never commit them to version control

### 2. Admin Panel Configuration

1. **Access Admin Panel**
   - Navigate to your admin dashboard
   - Go to **Settings** > **Payment Settings**

2. **Enable BayarCash Gateway**
   - Look for the BayarCash payment gateway card
   - Click on the card to open settings
   - Toggle the "Enable" switch

3. **Enter Credentials**
   - **Portal Key**: Enter your BayarCash portal key
   - **PAT Key**: Enter your Personal Access Token
   - **Secret Key**: Enter your API secret key
   - **Sandbox Mode**: Enable for testing, disable for production

4. **Save Configuration**
   - Click "Save Settings"
   - Verify the configuration shows as "Active"

## 🔧 Post-Installation Setup

### 1. Test Payment Flow

1. **Create Test Invoice**
   ```bash
   # If you have artisan commands for creating test data
   php artisan make:test-invoice --amount=10.00
   ```

2. **Test Payment Process**
   - Navigate to the invoice payment page
   - Select BayarCash as payment method
   - Complete test payment using sandbox credentials

3. **Verify Webhook Reception**
   - Check application logs for webhook processing
   - Confirm invoice status changes to "paid"
   - Verify subscription activation

### 2. Configure SSL (Production)

For production environments:

1. **Ensure SSL Certificate**
   ```bash
   # Verify SSL is working
   curl -I https://yourdomain.com
   ```

2. **Update Webhook URLs**
   - Use HTTPS URLs in BayarCash dashboard
   - Test webhook delivery

### 3. Set Up Monitoring

1. **Log Monitoring**
   ```bash
   # Monitor payment logs
   tail -f storage/logs/laravel.log | grep BayarCash
   ```

2. **Health Checks**
   ```php
   // Add to your health check endpoint
   $gateway = app('bayarcash.gateway');
   $status = $gateway->isActive() ? 'active' : 'inactive';
   ```

## 🧪 Testing

### 1. Sandbox Testing

Enable sandbox mode for testing:

```env
BAYARCASH_SANDBOX=true
```

### 2. Test Payment Methods

Test each supported payment method:

- **FPX Online Banking**: Use test bank credentials
- **DuitNow QR**: Use BayarCash test QR codes
- **Credit Cards**: Use test card numbers
- **E-Wallets**: Use sandbox wallet credentials

### 3. Webhook Testing

Use ngrok for local webhook testing:

```bash
# Install ngrok
npm install -g ngrok

# Expose local server
ngrok http 80

# Update webhook URL in BayarCash dashboard
https://your-ngrok-id.ngrok.io/{subdomain}/payment/bayarcash/webhook
```

## 🔍 Verification Checklist

Before going live, verify:

- [ ] ✅ Module loads without errors
- [ ] ✅ BayarCash gateway appears in payment options
- [ ] ✅ Test payments complete successfully
- [ ] ✅ Webhooks are received and processed
- [ ] ✅ Invoices are marked as paid automatically
- [ ] ✅ Subscriptions are activated after payment
- [ ] ✅ Error handling works correctly
- [ ] ✅ Logs show detailed information
- [ ] ✅ SSL is configured (production only)
- [ ] ✅ Credentials are secure

## 🚨 Troubleshooting

### Common Installation Issues

**1. Module Not Loading**
```bash
# Check module is in correct directory
ls -la Modules/BayarCash/

# Clear cache
php artisan cache:clear
php artisan config:clear
```

**2. SDK Not Found**
```bash
# Install BayarCash SDK
composer require webimpian/bayarcash-php-sdk:^2.0

# Check autoloader
composer dump-autoload
```

**3. Gateway Not Showing**
```bash
# Check logs for errors
tail -f storage/logs/laravel.log

# Verify environment variables
php artisan config:show | grep BAYARCASH
```

**4. Webhook Issues**
```bash
# Test webhook URL accessibility
curl -X POST https://yourdomain.com/{subdomain}/payment/bayarcash/webhook

# Check webhook logs
grep "BayarCash webhook" storage/logs/laravel.log
```

### Error Resolution

**Permission Issues**
```bash
# Fix directory permissions
chmod -R 755 Modules/BayarCash/
chown -R www-data:www-data Modules/BayarCash/
```

**Database Issues**
```bash
# Run migrations if needed
php artisan migrate

# Check settings table
php artisan tinker
>>> app(App\Settings\PaymentSettings::class)->bayarcash_enabled
```

## 📞 Support

If you encounter issues during installation:

1. **Check Logs**: Review Laravel logs for detailed error messages
2. **Documentation**: Refer to the main README.md file
3. **BayarCash Support**: Contact BayarCash for API-related issues
4. **Module Support**: Create an issue in the module repository

## 🔄 Updating

To update the module:

1. **Backup Configuration**
   ```bash
   cp Modules/BayarCash/Config/config.php backup/
   ```

2. **Update Module**
   ```bash
   # Manual update
   cp -r /path/to/new/BayarCash Modules/

   # Or via Composer
   composer update modules/bayarcash
   ```

3. **Clear Cache**
   ```bash
   php artisan cache:clear
   php artisan config:clear
   php artisan route:clear
   ```

4. **Test Functionality**
   - Verify payment processing
   - Test webhook reception
   - Check logs for errors

## ✅ Next Steps

After successful installation:

1. **Configure Production Settings**: Switch to production credentials
2. **Set Up Monitoring**: Implement payment monitoring and alerts
3. **Train Users**: Educate admin users on the new payment gateway
4. **Go Live**: Enable for production use
5. **Monitor Performance**: Track payment success rates and response times

Congratulations! Your BayarCash Payment Gateway is now ready for use. 🎉