# BayarCash Payment Gateway Module

## 📋 Overview

The BayarCash Payment Gateway Module provides comprehensive payment processing for Malaysian businesses, supporting:

- **BayarCash FPX** - FPX Online Banking (direct bank transfers)
- **BayarCash DuitNow QR** - DuitNow QR code payments

## 🚀 Quick Installation

### Step 1: Upload Module
1. Extract the module zip file
2. Upload the `BayarCash` folder to your `Modules/` directory
3. Ensure the folder structure is: `Modules/BayarCash/`

### Step 2: Install Dependencies
```bash
composer require webimpian/bayarcash-php-sdk:^2.0
```

### Step 3: Clear Cache
```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
```

### Step 4: Activate Module
The module will automatically register its services. No manual activation required.

## ⚙️ Configuration

### Admin Panel Setup
1. Navigate to **Admin Panel** > **Settings** > **Payment Methods**
2. Find **BayarCash** section
3. Configure the following settings:

**Required Settings:**
- **Enable BayarCash**: Toggle to enable payment gateway
- **Portal Key**: Your BayarCash portal identifier
- **Personal Access Token (PAT)**: API authentication token
- **API Secret Key**: For webhook signature validation
- **Sandbox Mode**: Enable for testing (disable for production)

### Obtaining BayarCash Credentials

1. **Sign up**: Create account at [bayarcash.com](https://bayarcash.com)
2. **Get verified**: Complete merchant verification
3. **API Access**: Navigate to Settings > API Keys in your dashboard
4. **Webhook Setup**: Add webhook URL: `https://yourdomain.com/{subdomain}/payment/bayarcash/webhook`

## 💳 Payment Methods Available

After configuration, customers will see:

1. **BayarCash FPX** - FPX Online Banking
   - Direct bank transfers from Malaysian banks
   - Suitable for customers with online banking

2. **BayarCash DuitNow QR** - DuitNow QR Payments
   - QR code scanning via mobile banking apps
   - Suitable for mobile users with banking apps

## 🔧 Testing

### Sandbox Testing
1. Set **Sandbox Mode** to `Yes` in admin panel
2. Use BayarCash sandbox credentials
3. Test transactions will be processed through sandbox environment

### Production
1. Set **Sandbox Mode** to `No`
2. Use production BayarCash credentials
3. Real transactions will be processed

## 🛡️ Security Features

- **Webhook Validation**: HMAC SHA256 signature verification
- **Transaction Verification**: Double verification for all payments
- **Secure Redirects**: Proper return URL handling
- **Error Handling**: Comprehensive error logging and handling

## 📝 Transaction Flow

1. Customer selects BayarCash payment method
2. Redirected to BayarCash payment page
3. Customer completes payment (FPX or QR)
4. BayarCash processes payment
5. Customer redirected back to your site
6. Webhook confirms payment status
7. Invoice automatically marked as paid
8. Subscription activated (if applicable)

## 🔍 Troubleshooting

### Common Issues

**Payment not completing:**
- Check webhook URL is correctly configured
- Verify API credentials are correct
- Ensure sandbox/production mode matches credentials

**Module not appearing:**
- Clear cache: `php artisan cache:clear`
- Check composer autoload: `composer dump-autoload`
- Verify module folder structure

### Logs
Payment activities are logged in `storage/logs/laravel.log`

## 📞 Support

For technical issues:
1. Check Laravel logs for error details
2. Verify BayarCash dashboard for transaction status
3. Ensure webhook endpoints are accessible

For BayarCash account issues:
- Contact BayarCash support directly
- Check BayarCash documentation at [docs.bayarcash.com](https://docs.bayarcash.com)

---

**Note**: This module is standalone and does not require any core file modifications. Simply upload, install dependencies, and configure through the admin panel.