<?php

namespace Modules\BayarCash\Listeners;

use App\Events\PaymentSettingsViewRendering;

class AddBayarCashToPaymentSettings
{
    /**
     * Handle the event.
     */
    public function handle(PaymentSettingsViewRendering $event): void
    {
        // Get BayarCash settings
        $settings = get_batch_settings(['payment.bayarcash_enabled']);
        $settings = array_merge(['payment.bayarcash_enabled' => false], $settings);

        // Generate the BayarCash payment gateway card HTML
        $html = view('BayarCash::payment-gateway-card', [
            'isEnabled' => $settings['payment.bayarcash_enabled']
        ])->render();

        $event->addPaymentGateway($html);
    }
}