<x-app-layout>
    <x-slot:title>
        BayarCash Payment
    </x-slot:title>

    <div class="max-w-5xl mx-auto">
        <x-card>
            <!-- Header Section -->
            <x-slot:header>
                <div class="flex items-center space-x-3">
                    <div class="w-6 h-6 sm:w-10 sm:h-10 bg-green-100 rounded-full flex items-center justify-center">
                        <x-heroicon-o-credit-card class="w-6 h-6 text-green-600" />
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 dark:text-gray-300">
                            BayarCash Payment
                        </h2>
                        <p class="text-sm text-gray-500 dark:text-gray-300">
                            Secure payment via BayarCash - FPX, DuitNow QR, Credit Cards
                        </p>
                    </div>
                </div>
            </x-slot:header>

            <x-slot:content>
                <!-- Invoice Summary -->
                <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Payment Summary</h3>

                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600 dark:text-gray-400">Invoice Number:</span>
                            <span class="font-medium text-gray-900 dark:text-gray-100">{{ $invoice->invoice_number }}</span>
                        </div>

                        <div class="flex justify-between items-center">
                            <span class="text-gray-600 dark:text-gray-400">Description:</span>
                            <span class="font-medium text-gray-900 dark:text-gray-100">{{ $invoice->description ?? 'Subscription Payment' }}</span>
                        </div>

                        @if($remainingCredit > 0)
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600 dark:text-gray-400">Subtotal:</span>
                            <span class="font-medium text-gray-900 dark:text-gray-100">{{ $invoice->currency->symbol }}{{ number_format($invoice->total(), 2) }}</span>
                        </div>

                        <div class="flex justify-between items-center text-green-600 dark:text-green-400">
                            <span>Credit Applied:</span>
                            <span class="font-medium">-{{ $invoice->currency->symbol }}{{ number_format($remainingCredit, 2) }}</span>
                        </div>
                        @endif

                        <div class="border-t border-gray-200 dark:border-gray-600 pt-3">
                            <div class="flex justify-between items-center">
                                <span class="text-lg font-semibold text-gray-900 dark:text-gray-100">Total:</span>
                                <span class="text-lg font-bold text-green-600 dark:text-green-400">
                                    {{ $invoice->currency->symbol }}{{ number_format($finalAmount, 2) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Processing -->
                <div class="text-center" x-data="{
                    processing: false,
                    redirecting: false,
                    init() {
                        this.startPayment();
                    },
                    startPayment() {
                        this.processing = true;
                        // Simulate payment initialization
                        setTimeout(() => {
                            this.processing = false;
                            this.redirecting = true;
                            // Redirect to actual payment URL
                            window.location.href = '{{ $paymentUrl ?? '#' }}';
                        }, 2000);
                    }
                }">
                    <div x-show="processing" class="py-8">
                        <div class="inline-flex items-center justify-center w-16 h-16 bg-green-100 rounded-full mb-4">
                            <svg class="animate-spin w-8 h-8 text-green-600" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-2">
                            Initializing Payment
                        </h3>
                        <p class="text-gray-600 dark:text-gray-400">
                            Please wait while we prepare your payment...
                        </p>
                    </div>

                    <div x-show="redirecting" class="py-8">
                        <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-100 rounded-full mb-4">
                            <x-heroicon-o-arrow-top-right-on-square class="w-8 h-8 text-blue-600" />
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-2">
                            Redirecting to BayarCash
                        </h3>
                        <p class="text-gray-600 dark:text-gray-400">
                            You will be redirected to BayarCash to complete your payment...
                        </p>
                    </div>
                </div>

                <!-- Payment Options Info -->
                <div class="mt-8 bg-blue-50 dark:bg-blue-900/20 rounded-lg p-6">
                    <h4 class="text-lg font-semibold text-blue-900 dark:text-blue-100 mb-3">
                        Available Payment Methods
                    </h4>
                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                                <x-heroicon-o-building-library class="w-4 h-4 text-white" />
                            </div>
                            <span class="text-sm text-blue-800 dark:text-blue-200">FPX Online Banking</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                                <x-heroicon-o-qr-code class="w-4 h-4 text-white" />
                            </div>
                            <span class="text-sm text-blue-800 dark:text-blue-200">DuitNow QR</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                                <x-heroicon-o-credit-card class="w-4 h-4 text-white" />
                            </div>
                            <span class="text-sm text-blue-800 dark:text-blue-200">Credit/Debit Cards</span>
                        </div>
                    </div>
                    <p class="text-sm text-blue-700 dark:text-blue-300 mt-3">
                        Choose your preferred payment method on the BayarCash payment page.
                    </p>
                </div>

                <!-- Security Note -->
                <div class="mt-6 text-center">
                    <div class="inline-flex items-center space-x-2 text-sm text-gray-600 dark:text-gray-400">
                        <x-heroicon-o-shield-check class="w-5 h-5 text-green-500" />
                        <span>Secured by BayarCash SSL encryption</span>
                    </div>
                </div>

                <!-- Cancel Option -->
                <div class="mt-6 text-center">
                    <a href="{{ route('tenant.invoices.show', $invoice) }}"
                       class="text-sm text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200">
                        Cancel and return to invoice
                    </a>
                </div>
            </x-slot:content>
        </x-card>
    </div>

    @push('scripts')
    <script>
        // Handle browser back button
        window.addEventListener('popstate', function(event) {
            window.location.href = '{{ route('tenant.invoices.show', $invoice) }}';
        });

        // Add timeout fallback
        setTimeout(function() {
            if (!window.redirecting) {
                window.location.href = '{{ route('tenant.invoices.show', $invoice) }}';
            }
        }, 30000); // 30 second timeout
    </script>
    @endpush
</x-app-layout>