<?php

use Spatie\LaravelSettings\Migrations\SettingsMigration;

class AddBayarcashToPaymentSettings extends SettingsMigration
{
    public function up(): void
    {
        $this->migrator->addEncrypted('payment.bayarcash_enabled', false);
        $this->migrator->addEncrypted('payment.bayarcash_portal_key', '');
        $this->migrator->addEncrypted('payment.bayarcash_pat_key', '');
        $this->migrator->addEncrypted('payment.bayarcash_api_secret_key', '');
        $this->migrator->addEncrypted('payment.bayarcash_sandbox', true);
    }

    public function down(): void
    {
        $this->migrator->delete('payment.bayarcash_enabled');
        $this->migrator->delete('payment.bayarcash_portal_key');
        $this->migrator->delete('payment.bayarcash_pat_key');
        $this->migrator->delete('payment.bayarcash_api_secret_key');
        $this->migrator->delete('payment.bayarcash_sandbox');
    }
}