<?php

return [
    'name' => 'BayarCash',

    /*
    |--------------------------------------------------------------------------
    | BayarCash Module Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration options for the BayarCash Payment Gateway Module.
    | These settings control the behavior and security of payment processing.
    |
    */

    'version' => '3.0.0',

    'security' => [
        'enforce_https' => env('BAYARCASH_ENFORCE_HTTPS', true),
        'validate_signatures' => true,
        'max_retry_attempts' => 3,
        'timeout_seconds' => 30,
    ],

    'logging' => [
        'enabled' => env('BAYARCASH_LOGGING', true),
        'level' => env('BAYARCASH_LOG_LEVEL', 'info'),
        'sensitive_data' => false, // Never log sensitive payment data
    ],

    'cache' => [
        'enabled' => true,
        'ttl' => 300, // 5 minutes
        'prefix' => 'bayarcash_',
    ],

    'payment_methods' => [
        'fpx' => [
            'enabled' => true,
            'name' => 'BayarCash FPX',
            'description' => 'Pay securely using FPX Online Banking',
        ],
        'duitnow_qr' => [
            'enabled' => true,
            'name' => 'BayarCash DuitNow QR',
            'description' => 'Pay securely using DuitNow QR',
        ],
    ],
];
