# BayarCash Production 500 Error - SDK Missing Fix

## 🚨 **Issue**: SDK installed in `/vendor` but module can't find it

**Error**: Module says "missing for module" even though BayarCash SDK is in `/vendor`

## 🔧 **Solution 1: Force Autoloader Refresh (Try First)**

On your production server (`wao.my`):

```bash
cd /var/www/wao.my

# 1. Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# 2. Regenerate autoloader with optimization
composer dump-autoload --optimize

# 3. Re-activate module
php artisan module:deactivate BayarCash
php artisan module:activate BayarCash

# 4. Test if it works
php artisan tinker --execute="echo app('bayarcash.gateway')->getName();"
```

## 🔧 **Solution 2: Manual SDK Check**

Test if the SDK is actually accessible:

```bash
php artisan tinker
```

In tinker:
```php
// Test 1: Check if class exists
class_exists('Webimpian\BayarcashSdk\Bayarcash');

// Test 2: Try to instantiate
$sdk = new \Webimpian\BayarcashSdk\Bayarcash('test', 'test', 'test');
echo get_class($sdk);

// Test 3: Check autoloader
print_r(get_declared_classes());
```

## 🔧 **Solution 3: Force SDK Installation**

If autoloader refresh doesn't work:

```bash
# Remove and reinstall SDK
composer remove webimpian/bayarcash-php-sdk
composer require webimpian/bayarcash-php-sdk:^2.0

# Clear everything again
php artisan cache:clear
composer dump-autoload --optimize
```

## 🔧 **Solution 4: Check File Ownership**

Ensure correct permissions:

```bash
# Fix ownership
sudo chown -R www-data:www-data /var/www/wao.my/vendor/webimpian/
sudo chown -R www-data:www-data /var/www/wao.my/Modules/BayarCash/

# Fix permissions
sudo chmod -R 755 /var/www/wao.my/vendor/webimpian/
sudo chmod -R 755 /var/www/wao.my/Modules/BayarCash/
```

## 🔧 **Solution 5: Environment-Specific Autoloader**

Sometimes production has different autoloader behavior:

```bash
# Check PHP version match
php -v

# Check composer version
composer --version

# Force platform requirements check
composer install --no-dev --optimize-autoloader

# Alternative: Use dev dependencies temporarily
composer install --optimize-autoloader
```

## 📋 **Updated Package with Better Error Handling**

I've updated the module with better SDK detection. Use the new package:

**Package**: `BayarCash-Core-Module-FIXED-v3.0.0.tar.gz`

**New Features:**
- ✅ SDK availability check with clear error messages
- ✅ Better error logging
- ✅ Graceful failure handling

## 🔍 **Diagnostic Commands**

Run these to identify the exact issue:

```bash
# 1. Check if SDK is in vendor
ls -la vendor/webimpian/bayarcash-php-sdk/

# 2. Check composer autoload
grep -r "Webimpian" vendor/composer/

# 3. Check module autoload
php artisan tinker --execute="print_r(get_included_files());" | grep -i bayarcash

# 4. Test module directly
php artisan module:list | grep BayarCash

# 5. Check for specific error
tail -50 storage/logs/laravel-$(date +%Y-%m-%d).log | grep -i "bayarcash\|sdk\|missing"
```

## 🎯 **Most Likely Solution**

Based on the symptoms, try **Solution 1** first (autoloader refresh). This resolves 90% of production autoloader issues.

If that doesn't work, the error logs will now show exactly what's missing thanks to the updated error handling in the new package.

## 📞 **Next Steps**

1. Try Solution 1 (autoloader refresh)
2. If still failing, run the diagnostic commands
3. Share the output of: `tail -50 storage/logs/laravel-$(date +%Y-%m-%d).log`

The updated module will now give you a clear error message about what exactly is missing!