# BayarCash Module Activation Guide

## ✅ **Current Status**
The BayarCash module should now be **automatically active** as a core module. Here's how to verify and manually activate if needed:

## 🔍 **Check Module Status**

### Command Line Check:
```bash
php artisan module:list
```
You should see:
```
| BayarCash | 3.0.0 | BayarCash Payment Gateway Module | Active | CORE |
```

### Test Payment Gateways:
```bash
php artisan tinker
```
Then run:
```php
$fpx = app('bayarcash.gateway');
echo $fpx->getName(); // Should output: BayarCash FPX

$duitnow = app('bayarcash.duitnow.gateway');
echo $duitnow->getName(); // Should output: BayarCash DuitNow QR
```

## 🚀 **Manual Activation Methods**

### Method 1: Artisan Command
```bash
php artisan module:activate BayarCash
```

### Method 2: Enable Command
```bash
php artisan module:enable BayarCash
```

### Method 3: Cache Clear + Composer Dump
```bash
php artisan cache:clear
php artisan config:clear
composer dump-autoload
```

## 🔧 **If Module Shows as Inactive**

### Step 1: Check File Structure
Ensure your folder structure is:
```
Modules/
└── BayarCash/
    ├── module.json (should show "active": true, "type": "core")
    ├── composer.json
    ├── BayarCash.php
    └── ... (other files)
```

### Step 2: Force Activation
```bash
# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear

# Force enable the module
php artisan module:enable BayarCash

# Dump composer autoload
composer dump-autoload

# Check status again
php artisan module:list
```

### Step 3: Check Dependencies
```bash
# Install BayarCash SDK if not installed
composer require webimpian/bayarcash-php-sdk:^2.0

# Update composer autoload
composer dump-autoload
```

## 🎯 **Admin Panel Recognition**

If the admin panel doesn't show the module as active:

### Check Payment Settings
1. Go to **Admin Panel** → **Settings** → **Payment Methods**
2. Look for **BayarCash** section
3. If missing, the module may need manual registration

### Manual Registration Check
```bash
php artisan tinker
```
Run:
```php
$settings = app(\App\Settings\PaymentSettings::class);
dd($settings); // Check if bayarcash_enabled property exists
```

## 🚨 **Troubleshooting**

### Issue: Module shows "Inactive"
**Solution:**
```bash
php artisan module:activate BayarCash
php artisan cache:clear
```

### Issue: Routes not working
**Solution:**
```bash
php artisan route:clear
php artisan cache:clear
```

### Issue: Payment gateways not appearing
**Solution:**
```bash
composer require webimpian/bayarcash-php-sdk:^2.0
php artisan config:clear
php artisan cache:clear
```

### Issue: Admin panel doesn't recognize
**Solution:**
1. Check if `App\Settings\PaymentSettings` has BayarCash properties
2. Clear browser cache
3. Try accessing: `http://yourdomain.com/admin/settings/payment/bayarcash`

## ✅ **Expected Results After Activation**

1. **Module Status**: Shows as "Active" and "CORE" type
2. **Routes Available**: BayarCash payment and admin routes work
3. **Payment Methods**: Two options appear:
   - BayarCash FPX
   - BayarCash DuitNow QR
4. **Admin Settings**: BayarCash section in payment settings

## 📞 **Final Verification Commands**

Run these to confirm everything is working:
```bash
# Check module is active
php artisan module:list | grep BayarCash

# Check routes are registered
php artisan route:list --name=bayarcash

# Test gateways are working
php artisan tinker --execute="echo app('bayarcash.gateway')->getName();"
```

If all commands work successfully, your BayarCash module is fully activated and ready to use!