# 🔧 Composer Configuration for BayarCash Module

## Required Dependencies

Add these to your main `composer.json` file if not already present:

```json
{
    "require": {
        "webimpian/bayarcash-php-sdk": "^2.0"
    }
}
```

## Installation Commands

### Option 1: Direct Install (Recommended)
```bash
composer require webimpian/bayarcash-php-sdk:^2.0
```

### Option 2: Manual composer.json Edit
1. Add the dependency to your `composer.json`
2. Run: `composer update webimpian/bayarcash-php-sdk`

### Option 3: Full Install (if starting fresh)
```bash
composer install --no-dev --optimize-autoloader
```

## Verification

Check the SDK is installed:
```bash
composer show webimpian/bayarcash-php-sdk
```

Should show version 2.0.5 or higher.

## Troubleshooting

**Missing extensions?**
Enable these PHP extensions:
- `ext-json`
- `ext-curl`
- `ext-openssl`

**Platform requirements?**
Add to composer.json if needed:
```json
{
    "config": {
        "platform-check": false
    }
}
```

**Cache issues?**
```bash
composer dump-autoload --optimize
```