# ✅ BayarCash Production Deployment Checklist

## 🎯 **Pre-Deployment Requirements**

### **BayarCash Account Setup**
- [ ] BayarCash merchant account activated
- [ ] Production Portal Key obtained
- [ ] Production PAT Key obtained
- [ ] API Token configured
- [ ] API Secret Key secured

### **Server Requirements**
- [ ] PHP 8.1+ installed with required extensions
- [ ] Laravel 10.0+ or 11.0+ framework
- [ ] Composer package manager available
- [ ] SSL certificate installed and verified
- [ ] Database access (MySQL/PostgreSQL)

---

## 📦 **Module Installation**

### **File Upload**
- [ ] Extract BayarCash module from package
- [ ] Upload to `your-website/Modules/BayarCash/`
- [ ] Verify all files uploaded correctly
- [ ] Check file permissions are correct

### **Dependency Installation**
```bash
# Install BayarCash SDK
composer require webimpian/bayarcash-php-sdk:^2.0

# Verify installation
composer show webimpian/bayarcash-php-sdk
```
- [ ] SDK installed successfully
- [ ] Version 2.0.5+ confirmed
- [ ] No dependency conflicts

### **Module Activation**
```bash
# Standard activation
php artisan module:activate BayarCash

# If dependency error, use workaround:
# 1. Edit Modules/BayarCash/module.json
# 2. Change "require": {"webimpian/bayarcash-php-sdk": "^2.0"} to "require": {}"
# 3. Run: php artisan module:activate BayarCash
# 4. Restore original require block
```
- [ ] Module activated without errors
- [ ] Shows as "Active" in module list
- [ ] Routes registered successfully

---

## ⚙️ **Configuration Setup**

### **Environment Variables**
Add to `.env` file:
```env
# Required
BAYARCASH_API_TOKEN=your_production_token
BAYARCASH_API_SECRET_KEY=your_production_secret

# Recommended
BAYARCASH_ENFORCE_HTTPS=true
BAYARCASH_LOGGING=true
```
- [ ] All required variables set
- [ ] Production credentials (not sandbox)
- [ ] Values properly secured

### **Admin Panel Configuration**
Navigate to: **Admin → Settings → Payment → BayarCash**
- [ ] Portal Key entered correctly
- [ ] PAT Key entered correctly
- [ ] Sandbox mode set to `false`
- [ ] Payment gateway enabled
- [ ] Settings saved successfully

### **Database Migration**
```bash
php artisan migrate
```
- [ ] Migration completed successfully
- [ ] Payment settings table updated
- [ ] No database errors

---

## 🧪 **Testing Phase**

### **Payment Method Verification**
- [ ] **BayarCash FPX** appears in checkout
- [ ] **BayarCash DuitNow QR** appears in checkout
- [ ] Payment options display correctly
- [ ] Descriptions are accurate

### **FPX Banking Test**
- [ ] Select FPX payment method
- [ ] Redirects to BayarCash payment page
- [ ] Can select bank from list
- [ ] Payment processing works
- [ ] Returns to site after payment
- [ ] Transaction status updates correctly

### **DuitNow QR Test**
- [ ] Select DuitNow QR payment method
- [ ] QR code displays correctly
- [ ] Mobile banking app can scan QR
- [ ] Payment processes successfully
- [ ] Returns to site after payment
- [ ] Transaction status updates correctly

### **Multi-Tenant Testing** (if applicable)
- [ ] Payments work across different subdomains
- [ ] Tenant-specific URLs generated correctly
- [ ] Payment isolation between tenants
- [ ] Callback URLs include correct tenant info

---

## 🛡️ **Security Verification**

### **HTTPS Configuration**
```bash
# Test SSL certificate
curl -I https://yourdomain.com/tenant/payment/bayarcash/callback
```
- [ ] SSL certificate valid and trusted
- [ ] All payment pages use HTTPS
- [ ] HTTP redirects to HTTPS
- [ ] No mixed content warnings

### **Callback URL Testing**
```bash
# Test callback accessibility
curl -X POST https://yourdomain.com/tenant/payment/bayarcash/callback \
  -H "Content-Type: application/json" \
  -d '{}'
```
- [ ] Callback URL accessible externally
- [ ] Returns appropriate response (200/405)
- [ ] No authentication errors
- [ ] Proper routing to handler

### **Error Handling**
- [ ] Failed payments handle gracefully
- [ ] Payment timeouts handled properly
- [ ] Invalid data rejected appropriately
- [ ] Error messages user-friendly

---

## 📊 **Performance Optimization**

### **Laravel Optimization**
```bash
# Clear all caches
php artisan optimize:clear

# Generate production caches
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Optimize autoloader
composer dump-autoload --optimize
```
- [ ] Configuration cached
- [ ] Routes cached
- [ ] Views cached
- [ ] Autoloader optimized

### **Performance Testing**
- [ ] Payment pages load quickly (<3 seconds)
- [ ] No memory leaks during payment flow
- [ ] Database queries optimized
- [ ] No unnecessary API calls

---

## 📝 **Monitoring Setup**

### **Logging Configuration**
- [ ] Laravel logs configured properly
- [ ] BayarCash logging enabled
- [ ] Log rotation configured
- [ ] Sensitive data not logged

### **Error Monitoring**
```bash
# Monitor logs during testing
tail -f storage/logs/laravel.log
```
- [ ] No errors during payment flow
- [ ] Warnings addressed appropriately
- [ ] Debug information sufficient

### **Payment Monitoring**
- [ ] Transaction status tracking working
- [ ] Payment history displays correctly
- [ ] Failed payments logged properly
- [ ] Success notifications sent

---

## 🚀 **Go-Live Process**

### **Final Verification**
- [ ] All tests passed successfully
- [ ] No outstanding errors or warnings
- [ ] Documentation reviewed and accurate
- [ ] Team briefed on new payment gateway

### **Deployment**
- [ ] Maintenance mode enabled (if needed)
- [ ] Module deployed to production
- [ ] Caches cleared and regenerated
- [ ] Maintenance mode disabled

### **Post-Deployment Monitoring**
- [ ] Monitor first few transactions closely
- [ ] Check error logs for issues
- [ ] Verify customer payment experience
- [ ] Confirm with BayarCash if needed

---

## 🆘 **Rollback Plan**

### **If Issues Occur**
1. **Immediate Actions**
   - [ ] Disable BayarCash payment gateway in admin
   - [ ] Enable alternative payment methods
   - [ ] Notify customers of temporary issue

2. **Investigation**
   - [ ] Check Laravel logs for errors
   - [ ] Review BayarCash transaction status
   - [ ] Verify configuration settings
   - [ ] Test in staging environment

3. **Recovery**
   - [ ] Fix identified issues
   - [ ] Re-test payment flow thoroughly
   - [ ] Re-enable gateway when confirmed working
   - [ ] Monitor closely for 24 hours

---

## 📞 **Support Contacts**

### **Technical Support**
- **Laravel Issues**: Development team
- **BayarCash API**: BayarCash merchant support
- **Server Issues**: Hosting provider
- **SSL Certificate**: Certificate provider

### **Emergency Procedures**
- **Payment Gateway Down**: Disable in admin panel
- **Security Breach**: Immediately disable and investigate
- **Server Issues**: Contact hosting provider
- **Customer Complaints**: Check transaction logs

---

**✅ Deployment Complete!**

Your BayarCash Payment Gateway is now live and ready to process payments. Monitor the system closely for the first 24-48 hours and address any issues promptly.

**Date Deployed**: _______________
**Deployed By**: _______________
**Verified By**: _______________