# 🚀 BayarCash Payment Gateway - Final Production Guide

## 📋 Overview

**BayarCash Payment Gateway Module v3.0.0** - A production-ready, optimized payment gateway supporting FPX Online Banking and DuitNow QR payments for Malaysian businesses.

### ✨ Key Features
- ✅ **Multi-Payment Methods**: FPX Banking & DuitNow QR
- ✅ **Multi-Tenant Support**: Works with subdomain-based tenancy
- ✅ **Production Optimized**: Enhanced performance and security
- ✅ **Laravel 10/11 Compatible**: Modern framework support
- ✅ **Secure Implementation**: HTTPS enforcement and signature validation

---

## 🎯 Quick Start (5 Minutes)

### **Step 1: Upload Module**
Extract and upload the BayarCash folder to:
```
your-website/Modules/BayarCash/
```

### **Step 2: Install SDK**
```bash
cd /path/to/your/website
composer require webimpian/bayarcash-php-sdk:^2.0
```

### **Step 3: Activate Module**
```bash
# Method 1: Normal activation
php artisan module:activate BayarCash

# Method 2: If dependency error occurs
# Edit Modules/BayarCash/module.json
# Change "require": {"webimpian/bayarcash-php-sdk": "^2.0"} to "require": {}
# Run: php artisan module:activate BayarCash
# Restore original require block
```

### **Step 4: Configure Environment**
Add to `.env`:
```env
BAYARCASH_API_TOKEN=your_production_token
BAYARCASH_API_SECRET_KEY=your_production_secret
BAYARCASH_ENFORCE_HTTPS=true
BAYARCASH_LOGGING=true
```

### **Step 5: Admin Configuration**
- Navigate to: **Admin Panel → Settings → Payment → BayarCash**
- Enter your BayarCash credentials:
  - Portal Key
  - PAT Key
- Set **Sandbox Mode** to `false` for production
- Enable the payment gateway

---

## 🔧 Advanced Configuration

### **Environment Variables**
```env
# Required
BAYARCASH_API_TOKEN=your_token
BAYARCASH_API_SECRET_KEY=your_secret

# Optional (with defaults)
BAYARCASH_ENFORCE_HTTPS=true
BAYARCASH_LOGGING=true
BAYARCASH_LOG_LEVEL=info
```

### **Module Configuration**
Edit `Modules/BayarCash/Config/config.php` for:
- Security settings
- Logging preferences
- Cache configuration
- Payment method enablement

---

## 🛡️ Security Features

### **Production Security**
- ✅ **HTTPS Enforcement**: All payments require SSL
- ✅ **Signature Validation**: API responses verified
- ✅ **Secure Credentials**: Environment-based configuration
- ✅ **Input Validation**: All payment data sanitized
- ✅ **No Sensitive Logging**: Payment details never logged

### **Multi-Tenant Security**
- ✅ **Isolated Payments**: Each tenant's payments separated
- ✅ **Dynamic URLs**: Tenant-specific callback URLs
- ✅ **Secure Routing**: Proper middleware protection

---

## 🧪 Testing Checklist

### **Payment Flow Testing**
- [ ] FPX Banking payment completes successfully
- [ ] DuitNow QR payment works with mobile banking
- [ ] Payment status updates correctly after completion
- [ ] Failed payments handle gracefully
- [ ] Multi-tenant payments work across subdomains

### **Admin Panel Testing**
- [ ] Settings page loads without errors
- [ ] Configuration saves correctly
- [ ] Payment methods appear in checkout
- [ ] Transaction history displays properly

---

## 🐛 Troubleshooting

### **Module Activation Issues**
**Error**: "Dependency webimpian/bayarcash-php-sdk not installed"
```bash
# Solution 1: Edit module.json temporarily
# Change "require": {"webimpian/bayarcash-php-sdk": "^2.0"} to "require": {}"
# Activate module, then restore original require block

# Solution 2: Force install SDK
composer require webimpian/bayarcash-php-sdk:^2.0
```

### **Admin Settings 500 Error**
**Error**: "Target class [admin] does not exist"
```bash
# Clear all caches
php artisan optimize:clear

# Or manually clear
php artisan config:clear
php artisan route:clear
php artisan cache:clear
```

### **Payment Loop Issues**
**Problem**: Payment redirects in loop
```bash
# Check Laravel logs
tail -f storage/logs/laravel.log

# Verify URLs are generated correctly
# Check tenant routing is working
php artisan route:list | grep bayarcash
```

### **SSL Certificate Issues**
**Problem**: Payments fail with HTTPS errors
```bash
# Test SSL certificate
curl -I https://yourdomain.com/tenant/payment/bayarcash/callback

# Should return HTTP 200 or 405, not SSL errors
```

---

## 📊 Performance Optimization

### **Cache Configuration**
- ✅ **Gateway Singletons**: Payment gateways cached
- ✅ **Config Caching**: Settings cached for performance
- ✅ **Route Caching**: Optimized route resolution

### **Production Commands**
```bash
# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache
composer dump-autoload --optimize
```

---

## 📞 Support & Maintenance

### **Version Information**
- **Module Version**: 3.0.0
- **SDK Version**: webimpian/bayarcash-php-sdk ^2.0
- **Laravel Compatibility**: 10.0+ and 11.0+
- **PHP Version**: 8.1+

### **BayarCash Support**
- **Documentation**: https://docs.bayarcash.com
- **Merchant Dashboard**: Login to configure Portal/PAT keys
- **API Support**: Contact BayarCash for API issues

### **Module Updates**
- Monitor GitHub releases for updates
- Always test in staging before production
- Keep SDK updated for security patches

---

## ✅ Production Deployment Checklist

**Pre-Deployment**
- [ ] BayarCash merchant account activated
- [ ] Production API credentials obtained
- [ ] SSL certificate installed and verified
- [ ] Laravel application optimized for production

**Module Installation**
- [ ] BayarCash module uploaded to Modules/BayarCash/
- [ ] SDK installed via Composer
- [ ] Module activated successfully
- [ ] Database migrations run

**Configuration**
- [ ] Environment variables set correctly
- [ ] Admin panel settings configured
- [ ] Sandbox mode disabled
- [ ] Payment methods enabled

**Testing**
- [ ] Test FPX payment flow
- [ ] Test DuitNow QR payment flow
- [ ] Verify multi-tenant functionality
- [ ] Check transaction status updates
- [ ] Validate error handling

**Go Live**
- [ ] Monitor payment processing
- [ ] Check Laravel logs for errors
- [ ] Verify webhook callbacks working
- [ ] Test customer payment experience

---

**🎉 Congratulations! Your BayarCash Payment Gateway is production-ready!**

For additional support or questions, refer to the troubleshooting section or contact your development team.