<?php

namespace Modules\BayarCash\Listeners;

use App\Events\PaymentGatewayRegistration;
use App\Settings\PaymentSettings;
use Modules\BayarCash\Services\BayarCashPaymentGateway;
use Modules\BayarCash\Services\BayarCashDuitNowQrPaymentGateway;

class RegisterBayarCashPaymentGateway
{
    /**
     * Handle the event.
     */
    public function handle(PaymentGatewayRegistration $event): void
    {
        $settings = app(PaymentSettings::class);

        // Check if BayarCash is enabled and configured
        $isConfigured = $settings->bayarcash_enabled &&
            !empty($settings->bayarcash_portal_key) &&
            !empty($settings->bayarcash_pat_key) &&
            !empty($settings->bayarcash_api_secret_key);

        if ($isConfigured) {
            // Register BayarCash FPX gateway (renamed from original BayarCash)
            $event->billingManager->register('bayarcash_fpx', function () {
                return app(BayarCashPaymentGateway::class);
            });

            // Register BayarCash DuitNow QR gateway
            $event->billingManager->register('bayarcash_duitnow_qr', function () {
                return app(BayarCashDuitNowQrPaymentGateway::class);
            });
        }
    }
}