# BayarCash Payment Gateway Module v3.1.0

Malaysian payment gateway supporting FPX Online Banking and DuitNow QR.

## Requirements

- PHP 8.1+
- Laravel 10.0+, 11.0+, or 12.0+
- `webimpian/bayarcash-php-sdk:^2.0`

---

## Installation

```bash
# 1. Upload Modules/BayarCash/ folder to your server

# 2. Install SDK (REQUIRED - not in original Whatsmark)
composer require webimpian/bayarcash-php-sdk:^2.0

# 3. Clear cache
php artisan cache:clear && php artisan config:clear && php artisan route:clear

# 4. Regenerate autoloader
composer dump-autoload --optimize

# 5. Activate module
php artisan module:activate BayarCash

# 6. Verify
php artisan tinker --execute="echo app('bayarcash.gateway')->getName();"
# Should output: "BayarCash FPX"
```

---

## After Whatsmark Core Update

**IMPORTANT**: Whatsmark does NOT include BayarCash SDK. Run these after every update:

```bash
# Backup first
# - Modules/BayarCash/
# - .env

# After update, restore module then run:
composer require webimpian/bayarcash-php-sdk:^2.0
php artisan cache:clear && php artisan config:clear
composer dump-autoload --optimize
php artisan module:deactivate BayarCash && php artisan module:activate BayarCash
```

---

## Configuration

**Admin Panel**: `/admin/settings/payment/bayarcash`

| Field | Description |
|-------|-------------|
| Portal Key | From BayarCash merchant dashboard |
| PAT Key | Personal Access Token |
| API Secret Key | For webhook signature validation |
| Sandbox Mode | Enable for testing |

**Webhook URL** (set in BayarCash dashboard):
```
https://yourdomain.com/{tenant-subdomain}/payment/bayarcash/webhook
```

---

## Verification Commands

```bash
php artisan module:list | grep BayarCash
composer show webimpian/bayarcash-php-sdk
php artisan route:list | grep bayarcash
```

---

## Troubleshooting

| Error | Solution |
|-------|----------|
| SDK not found | `composer require webimpian/bayarcash-php-sdk:^2.0` |
| Route not defined | `php artisan route:clear && php artisan cache:clear` |
| Module inactive | `php artisan module:activate BayarCash` |
| 419 CSRF error | Webhooks auto-exempted in routes |

**Check logs**:
```bash
tail -100 storage/logs/laravel.log | grep -i bayarcash
```

---

## Payment Methods

| Method | Type ID |
|--------|---------|
| FPX Online Banking | `bayarcash_fpx` |
| DuitNow QR | `bayarcash_duitnow_qr` |

---

## Changelog

### v3.1.0 (2025-12-22)
- Added CSRF exemption for webhooks
- Added rate limiting on checkout (10/min)
- Fixed race condition with database locking
- Masked sensitive data in logs
- Added input validation for credit amount

### v3.0.0
- Initial stable release

---

Last Updated: 2025-12-22
