<?php

namespace Modules\BayarCash\Listeners;

use App\Events\PaymentSettingsExtending;

class ExtendPaymentSettings
{
    /**
     * Handle the event.
     */
    public function handle(PaymentSettingsExtending $event): void
    {
        // Add BayarCash settings to dynamic settings
        $event->addExtension('bayarcash_enabled', false);
        $event->addExtension('bayarcash_portal_key', '');
        $event->addExtension('bayarcash_pat_key', '');
        $event->addExtension('bayarcash_api_secret_key', '');
        $event->addExtension('bayarcash_sandbox', true);
    }
}