<?php

namespace Modules\BayarCash;

class BayarCash
{
    /**
     * Module information.
     */
    public static function info(): array
    {
        return [
            'name' => 'BayarCash Payment Gateway',
            'description' => 'Comprehensive BayarCash Payment Gateway Module - Supports FPX and DuitNow QR for Malaysian market',
            'version' => '3.0.0',
            'author' => 'Payment Module Developer',
        ];
    }

    /**
     * Check if module is properly configured.
     */
    public static function isConfigured(): bool
    {
        $settings = app(\App\Settings\PaymentSettings::class);

        return $settings->bayarcash_enabled &&
            !empty($settings->bayarcash_portal_key) &&
            !empty($settings->bayarcash_pat_key) &&
            !empty($settings->bayarcash_api_secret_key);
    }
}
