<x-app-layout>
    <x-slot:title>
        BayarCash Payment Settings
    </x-slot:title>
    <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
        <div>
            <div class="flex flex-col sm:flex-row gap-4 sm:gap-0 sm:items-center justify-between">
                <div>
                    <h1 class="font-display text-3xl text-slate-900 dark:text-slate-200 font-medium">
                        BayarCash Payment Settings
                    </h1>
                    <p class="mt-2 text-base text-gray-600 dark:text-gray-400">
                        Configure BayarCash payment gateway for Malaysian payments (FPX, DuitNow QR, Credit Cards)
                    </p>
                </div>
                <x-button.secondary type="button" onclick="history.back()">
                    <x-heroicon-o-arrow-left class="w-5 h-5 mr-2" />
                    Back
                </x-button.secondary>
            </div>
        </div>

        <div class="bg-gray-50 dark:bg-gray-900 mt-6">
            <div class="max-w-7xl mx-auto">
                <!-- Main Content -->
                <form id="bayarcash-settings-form" method="POST"
                    action="{{ route('admin.settings.payment.bayarcash.update') }}" x-data="{
                        bayarcashEnabled: {{ $bayarcash_enabled ? 'true' : 'false' }},
                        webhookUrl: '{{ url('{subdomain}/payment/bayarcash/webhook') }}',
                        callbackUrl: '{{ url('{subdomain}/payment/bayarcash/callback') }}',
                        copyWebhookUrl() {
                            navigator.clipboard.writeText(this.webhookUrl)
                                .then(() => {
                                    window.dispatchEvent(new CustomEvent('notify', {
                                        detail: {
                                            type: 'success',
                                            message: 'Webhook URL copied to clipboard'
                                        }
                                    }));
                                })
                                .catch(() => {
                                    window.dispatchEvent(new CustomEvent('notify', {
                                        detail: {
                                            type: 'error',
                                            message: 'Failed to copy URL'
                                        }
                                    }));
                                });
                        },
                        copyCallbackUrl() {
                            navigator.clipboard.writeText(this.callbackUrl)
                                .then(() => {
                                    window.dispatchEvent(new CustomEvent('notify', {
                                        detail: {
                                            type: 'success',
                                            message: 'Callback URL copied to clipboard'
                                        }
                                    }));
                                })
                                .catch(() => {
                                    window.dispatchEvent(new CustomEvent('notify', {
                                        detail: {
                                            type: 'error',
                                            message: 'Failed to copy URL'
                                        }
                                    }));
                                });
                        }
                    }">
                    @csrf

                    <div class="space-y-8">
                        <!-- Gateway Status -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-lg p-6">
                            <div class="flex items-center justify-between">
                                <div>
                                    <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                                        Gateway Status
                                    </h3>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                        Enable or disable the BayarCash payment gateway
                                    </p>
                                </div>
                                <div class="flex items-center">
                                    <input type="hidden" name="bayarcash_enabled" value="0">
                                    <input type="checkbox" name="bayarcash_enabled" value="1"
                                        x-model="bayarcashEnabled"
                                        {{ $bayarcash_enabled ? 'checked' : '' }}
                                        class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                    <label class="ml-2 text-sm text-gray-900 dark:text-gray-100">
                                        Enable BayarCash
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- API Configuration -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-lg p-6"
                            x-show="bayarcashEnabled" x-transition>
                            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">
                                API Configuration
                            </h3>
                            <div class="grid grid-cols-1 gap-6">
                                <!-- Portal Key -->
                                <div>
                                    <label for="bayarcash_portal_key"
                                        class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                        Portal Key
                                    </label>
                                    <input type="text" name="bayarcash_portal_key" id="bayarcash_portal_key"
                                        value="{{ $bayarcash_portal_key }}"
                                        class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                        placeholder="Enter your BayarCash Portal Key">
                                    @error('bayarcash_portal_key')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Personal Access Token (PAT) Key -->
                                <div>
                                    <label for="bayarcash_pat_key"
                                        class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                        Personal Access Token (PAT) Key
                                    </label>
                                    <input type="password" name="bayarcash_pat_key" id="bayarcash_pat_key"
                                        value="{{ $bayarcash_pat_key }}"
                                        class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                        placeholder="Enter your BayarCash PAT Key">
                                    @error('bayarcash_pat_key')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- API Secret Key -->
                                <div>
                                    <label for="bayarcash_api_secret_key"
                                        class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                        API Secret Key
                                    </label>
                                    <input type="password" name="bayarcash_api_secret_key" id="bayarcash_api_secret_key"
                                        value="{{ $bayarcash_api_secret_key }}"
                                        class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                        placeholder="Enter your BayarCash API Secret Key">
                                    @error('bayarcash_api_secret_key')
                                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Sandbox Mode -->
                                <div>
                                    <div class="flex items-center">
                                        <input type="hidden" name="bayarcash_sandbox" value="0">
                                        <input type="checkbox" name="bayarcash_sandbox" value="1"
                                            {{ $bayarcash_sandbox ? 'checked' : '' }}
                                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                        <label class="ml-2 text-sm text-gray-900 dark:text-gray-100">
                                            Enable Sandbox Mode
                                        </label>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                        Use BayarCash sandbox environment for testing
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Webhook Configuration -->
                        <div class="bg-white dark:bg-gray-800 shadow-sm rounded-lg p-6"
                            x-show="bayarcashEnabled" x-transition>
                            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">
                                Webhook Configuration
                            </h3>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                        Webhook URL
                                    </label>
                                    <div class="mt-1 flex rounded-md shadow-sm">
                                        <input type="text" readonly :value="webhookUrl"
                                            class="flex-1 min-w-0 block w-full px-3 py-2 rounded-none rounded-l-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                        <button type="button" @click="copyWebhookUrl()"
                                            class="inline-flex items-center px-3 py-2 border border-l-0 border-gray-300 dark:border-gray-600 rounded-r-md bg-gray-50 dark:bg-gray-600 text-gray-500 dark:text-gray-300 text-sm">
                                            <x-heroicon-o-clipboard class="w-4 h-4" />
                                        </button>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                        Add this URL to your BayarCash webhook settings
                                    </p>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                        Callback URL
                                    </label>
                                    <div class="mt-1 flex rounded-md shadow-sm">
                                        <input type="text" readonly :value="callbackUrl"
                                            class="flex-1 min-w-0 block w-full px-3 py-2 rounded-none rounded-l-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                        <button type="button" @click="copyCallbackUrl()"
                                            class="inline-flex items-center px-3 py-2 border border-l-0 border-gray-300 dark:border-gray-600 rounded-r-md bg-gray-50 dark:bg-gray-600 text-gray-500 dark:text-gray-300 text-sm">
                                            <x-heroicon-o-clipboard class="w-4 h-4" />
                                        </button>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                        Add this URL to your BayarCash callback settings
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Setup Instructions -->
                        <div class="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-6"
                            x-show="bayarcashEnabled" x-transition>
                            <h3 class="text-lg font-medium text-blue-900 dark:text-blue-100 mb-4">
                                Setup Instructions
                            </h3>
                            <div class="space-y-3 text-sm text-blue-800 dark:text-blue-200">
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs font-bold mr-3 mt-0.5">
                                        1
                                    </div>
                                    <div>
                                        <strong>Get BayarCash Credentials:</strong>
                                        <p class="mt-1">Sign up for a BayarCash merchant account and obtain your Merchant ID, Verification Key, and Secret Key from the dashboard.</p>
                                    </div>
                                </div>
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs font-bold mr-3 mt-0.5">
                                        2
                                    </div>
                                    <div>
                                        <strong>Configure Webhooks:</strong>
                                        <p class="mt-1">In your BayarCash dashboard, add the webhook URL provided above to receive payment notifications.</p>
                                    </div>
                                </div>
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs font-bold mr-3 mt-0.5">
                                        3
                                    </div>
                                    <div>
                                        <strong>Test Configuration:</strong>
                                        <p class="mt-1">Enable sandbox mode and process a test payment to ensure everything is working correctly.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Save Button -->
                        <div class="flex justify-end">
                            <x-button.primary type="submit">
                                <x-heroicon-o-check class="w-5 h-5 mr-2" />
                                Save Settings
                            </x-button.primary>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>