# BayarCash Module - Production Deployment Guide

## 📦 Package Contents
- **BayarCash Module**: Complete module folder with all necessary files
- **Dependencies**: Requires `webimpian/bayarcash-php-sdk` v2.0+
- **Database**: Includes migration for payment settings

## 🚀 Pre-Deployment Checklist

### 1. Server Requirements
- ✅ PHP 8.1+ with required extensions
- ✅ Laravel 10.0+ or 11.0+
- ✅ Composer installed
- ✅ Database access (MySQL/PostgreSQL)

### 2. Required Dependencies
Ensure these packages are in your main `composer.json`:
```json
{
    "require": {
        "webimpian/bayarcash-php-sdk": "^2.0",
        "nwidart/laravel-modules": "^10.0"
    }
}
```

## 📋 Step-by-Step Deployment

### Step 1: Upload Module Files
1. **Extract the BayarCash folder** from the package
2. **Upload to your server** at: `your-website/Modules/BayarCash/`
3. **Verify folder structure**:
   ```
   Modules/
   └── BayarCash/
       ├── Config/
       ├── Database/
       ├── Http/
       ├── Providers/
       ├── Resources/
       ├── Routes/
       ├── Services/
       ├── composer.json
       └── module.json
   ```

### Step 2: Install Dependencies
Run these commands via SSH or hosting panel terminal:
```bash
# Navigate to your website root
cd /path/to/your/website

# Install/update dependencies
composer install --no-dev --optimize-autoloader

# OR if BayarCash SDK is missing:
composer require webimpian/bayarcash-php-sdk:^2.0
```

### Step 3: Activate Module
```bash
# Activate the BayarCash module
php artisan module:activate BayarCash

# If you get dependency error, use this workaround:
# 1. Temporarily edit Modules/BayarCash/module.json
# 2. Change "require": {"webimpian/bayarcash-php-sdk": "^2.0"} to "require": {}
# 3. Run: php artisan module:activate BayarCash
# 4. Restore the original require block
```

### Step 4: Run Database Migration
```bash
# Run the BayarCash payment settings migration
php artisan migrate

# Or specifically for the module:
php artisan module:migrate BayarCash
```

### Step 5: Clear Caches
```bash
# Clear all caches
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan cache:clear

# Regenerate optimized files
php artisan config:cache
php artisan route:cache
composer dump-autoload --optimize
```

### Step 6: Verify Installation
Check these endpoints work:
- ✅ `/admin/settings/payment/bayarcash` - Admin settings page
- ✅ `php artisan module:list` - Shows BayarCash as Active
- ✅ `php artisan route:list | grep bayarcash` - Shows 7 routes

## ⚙️ Configuration Setup

### Step 1: Environment Variables
Add to your `.env` file:
```env
# BayarCash API Configuration
BAYARCASH_API_TOKEN=your_api_token_here
BAYARCASH_API_SECRET_KEY=your_secret_key_here
```

### Step 2: Admin Panel Settings
1. **Login to admin panel**
2. **Navigate to**: Settings → Payment → BayarCash
3. **Configure**:
   - Portal Key: `your_portal_key`
   - PAT Key: `your_pat_key`
   - Sandbox Mode: `false` (for production)
   - Status: `Active`

### Step 3: Webhook URLs
Configure these URLs in your BayarCash merchant dashboard:
- **Return URL**: `https://yourdomain.com/{subdomain}/payment/bayarcash/return/{invoice}`
- **Callback URL**: `https://yourdomain.com/{subdomain}/payment/bayarcash/callback`
- **Webhook URL**: `https://yourdomain.com/{subdomain}/payment/bayarcash/webhook`

## 🔧 Troubleshooting

### Module Activation Issues
**Error**: "Dependency webimpian/bayarcash-php-sdk not installed"
**Solution**:
1. Edit `Modules/BayarCash/module.json`
2. Temporarily change `"require": {"webimpian/bayarcash-php-sdk": "^2.0"}` to `"require": {}`
3. Run `php artisan module:activate BayarCash`
4. Restore original require block
5. Run `composer dump-autoload`

### Routes Not Found
**Solution**:
```bash
php artisan route:clear
php artisan route:cache
```

### Payment Gateway Not Appearing
**Solution**:
1. Check module is active: `php artisan module:list`
2. Verify settings in admin panel
3. Clear config cache: `php artisan config:clear`

### SDK Class Not Found
**Solution**:
```bash
composer require webimpian/bayarcash-php-sdk:^2.0
composer dump-autoload
```

## ✅ Production Checklist

Before going live, verify:
- [ ] Module activated successfully
- [ ] All 7 BayarCash routes are registered
- [ ] Admin settings page accessible
- [ ] Environment variables set
- [ ] BayarCash merchant account configured
- [ ] Webhook URLs updated in merchant dashboard
- [ ] Test payment flow works
- [ ] SSL certificate installed (required for payments)

## 📞 Support Information

### BayarCash API Documentation
- Website: https://docs.bayarcash.com
- Support: Contact BayarCash support for API credentials

### Module Version Information
- **Version**: 3.0.0
- **Compatibility**: Laravel 10.0+, PHP 8.1+
- **SDK Version**: webimpian/bayarcash-php-sdk ^2.0

## 🔐 Security Notes

1. **Never commit sensitive data** to version control
2. **Use strong API keys** provided by BayarCash
3. **Enable SSL/HTTPS** for all payment pages
4. **Regularly update** SDK and module versions
5. **Monitor webhook logs** for security issues

---

**🎉 Deployment Complete!**

Your BayarCash payment gateway is now ready to process payments on your live website.