export default function typingHandler(io, socket) {
  /**
   * User started typing
   */
  socket.on('typing:start', (data) => {
    const { conversationId } = data;

    if (!conversationId) return;

    socket.to(`conversation:${conversationId}`).emit('typing:user', {
      userId: socket.userId,
      userName: socket.userName,
      conversationId,
    });
  });

  /**
   * User stopped typing
   */
  socket.on('typing:stop', (data) => {
    const { conversationId } = data;

    if (!conversationId) return;

    socket.to(`conversation:${conversationId}`).emit('typing:stop', {
      userId: socket.userId,
      conversationId,
    });
  });
}
