import logger from '../../utils/logger.js';

export default function conversationHandler(io, socket) {
  /**
   * Join a conversation room
   */
  socket.on('conversation:join', (data) => {
    const { conversationId } = data;

    if (!conversationId) return;

    socket.join(`conversation:${conversationId}`);
    logger.debug('Joined conversation', { userId: socket.userId, conversationId });
  });

  /**
   * Leave a conversation room
   */
  socket.on('conversation:leave', (data) => {
    const { conversationId } = data;

    if (!conversationId) return;

    socket.leave(`conversation:${conversationId}`);
    logger.debug('Left conversation', { userId: socket.userId, conversationId });
  });
}
