import { verifyToken } from '../services/laravel.js';
import logger from '../utils/logger.js';

/**
 * Socket.IO authentication middleware
 */
export async function authMiddleware(socket, next) {
  try {
    const token = socket.handshake.auth.token;

    if (!token) {
      logger.warn('Connection attempt without token');
      return next(new Error('Authentication required'));
    }

    const result = await verifyToken(token);

    if (!result.valid) {
      logger.warn('Invalid token provided');
      return next(new Error('Invalid token'));
    }

    // Attach user info to socket
    socket.userId = result.user.id;
    socket.tenantId = result.user.tenant_id;
    socket.userName = result.user.name;
    socket.token = token;

    logger.debug('User authenticated', { userId: socket.userId, tenantId: socket.tenantId });
    next();

  } catch (error) {
    logger.error('Auth middleware error:', error);
    next(new Error('Authentication failed'));
  }
}
