import 'dotenv/config';

export default {
  nodeEnv: process.env.NODE_ENV || 'development',
  port: parseInt(process.env.PORT, 10) || 3000,

  // Laravel API
  laravelUrl: process.env.LARAVEL_URL || 'http://wao.test',
  laravelApiUrl: process.env.LARAVEL_API_URL || 'http://wao.test/api',

  // Webhook secret (must match Laravel WAOCHAT_WEBHOOK_SECRET)
  webhookSecret: process.env.WEBHOOK_SECRET,

  // JWT secret for token validation
  jwtSecret: process.env.JWT_SECRET,

  // CORS origins
  corsOrigins: process.env.CORS_ORIGINS
    ? process.env.CORS_ORIGINS.split(',').map(s => s.trim())
    : ['https://wao.my', 'https://web.wao.my'],

  // Socket.IO settings
  socketIO: {
    pingTimeout: 60000,
    pingInterval: 25000,
    maxHttpBufferSize: 1e6,
    transports: ['websocket', 'polling'],
  },
};
