# WAO Chat PWA v2

A clean, modular real-time chat system for WhatsApp Business integration.

## Architecture

```
┌──────────────────────────────────────────────────────────────┐
│                     Single Server                             │
│                                                               │
│  wao.my (Laravel)              web.wao.my (Node.js)          │
│  ├── API endpoints             ├── Socket.IO                 │
│  ├── WaoChat module            ├── Vue.js PWA                │
│  └── WhatsApp webhook          └── HTTP webhooks             │
│                                                               │
│  Laravel ────HTTP Webhook────→ Node.js ────→ Clients         │
└──────────────────────────────────────────────────────────────┘
```

## Directory Structure

```
wao-app-v2/
├── src/                    # Node.js server source
│   ├── server.js          # Main Express + Socket.IO server
│   ├── config/            # Configuration
│   ├── middleware/        # Auth middleware
│   ├── routes/            # Webhook routes
│   ├── socket/            # Socket.IO handlers
│   ├── services/          # Laravel API client
│   └── utils/             # Logging
├── laravel-module/        # Laravel module (copy to wao.my)
│   └── WaoChat/           # Module files
├── logs/                  # Log files
├── dist/                  # Built Vue.js PWA (from client build)
├── package.json
├── ecosystem.config.cjs   # PM2 configuration
└── .env.example
```

## Quick Start

### 1. Node.js Server Setup

```bash
# On server
cd /var/www/web.wao.my
npm install --production
mkdir -p logs

# Create .env from example
cp .env.example .env
nano .env  # Edit with your values

# Start with PM2
pm2 start ecosystem.config.cjs
pm2 save
```

### 2. Laravel Module Setup

```bash
# Copy module to Laravel
cp -r laravel-module/WaoChat /var/www/wao.my/modules/

# Update composer.json autoload
# Register service provider
# Add .env variables
# Clear caches

# See laravel-module/README.md for details
```

### 3. Build Vue.js PWA

```bash
# On local machine
cd wao-app/client
VITE_API_URL=https://wao.my/api npm run build

# Upload dist/ to /var/www/web.wao.my/dist/
```

## Environment Variables

### Node.js (.env)

```env
NODE_ENV=production
PORT=3000
LARAVEL_URL=https://wao.my
LARAVEL_API_URL=https://wao.my/api
WEBHOOK_SECRET=your-secret  # Must match Laravel
CORS_ORIGINS=https://wao.my,https://web.wao.my
```

### Laravel (.env)

```env
WAOCHAT_ENABLED=true
WAOCHAT_NODEJS_URL=http://127.0.0.1:3000
WAOCHAT_WEBHOOK_SECRET=your-secret  # Must match Node.js
```

## Commands

```bash
# Node.js
pm2 restart wao-pwa
pm2 logs wao-pwa
curl http://127.0.0.1:3000/health

# Laravel
php artisan config:clear
curl https://wao.my/api/waochat/health
```

## Troubleshooting

1. **WebSocket not connecting**: Check OpenLiteSpeed proxy config
2. **CORS errors**: Verify CORS_ORIGINS in Node.js and cors.php in Laravel
3. **Webhook fails**: Check WEBHOOK_SECRET matches in both .env files
4. **Messages not sending**: Check Laravel logs and WhatsApp API credentials
