<?php

namespace Modules\WaoChat;

use Illuminate\Support\ServiceProvider;
use Modules\WaoChat\Services\RealtimeService;

class WaoChatServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Merge config
        $this->mergeConfigFrom(
            __DIR__ . '/../config/waochat.php', 'waochat'
        );

        // Register RealtimeService as singleton
        $this->app->singleton('waochat.realtime', function ($app) {
            return new RealtimeService();
        });
    }

    public function boot()
    {
        // Load routes
        $this->loadRoutesFrom(__DIR__ . '/../routes/api.php');

        // Publish config (optional)
        $this->publishes([
            __DIR__ . '/../config/waochat.php' => config_path('waochat.php'),
        ], 'waochat-config');
    }
}
