<?php

namespace Modules\WaoChat\Traits;

use Modules\WaoChat\Services\RealtimeService;

trait NotifiesRealtime
{
    /**
     * Get realtime service instance
     */
    protected function realtime(): RealtimeService
    {
        return app('waochat.realtime');
    }

    /**
     * Notify clients about new incoming message
     */
    protected function notifyNewMessage(
        int $chatId,
        int $messageId,
        int $tenantId,
        string $message,
        string $from,
        string $messageType = 'text',
        ?array $media = null
    ): bool {
        return $this->realtime()->notifyNewMessage([
            'id' => $messageId,
            'conversationId' => $chatId,
            'from' => $from,
            'to' => 'me',
            'message' => $message,
            'messageType' => $messageType,
            'media' => $media,
            'timestamp' => now()->timestamp * 1000,
            'tenantId' => $tenantId,
        ]);
    }

    /**
     * Notify clients about message status change
     */
    protected function notifyMessageStatus(
        int $conversationId,
        int $messageId,
        string $status,
        ?string $tempId = null,
        ?string $error = null
    ): bool {
        return $this->realtime()->notifyMessageStatus([
            'conversationId' => $conversationId,
            'messageId' => $messageId,
            'tempId' => $tempId,
            'status' => $status,
            'error' => $error,
            'timestamp' => now()->timestamp * 1000,
        ]);
    }

    /**
     * Notify clients about conversation update
     */
    protected function notifyConversationUpdate(int $conversationId, int $tenantId, array $data = []): bool
    {
        return $this->realtime()->notifyConversationUpdate([
            'conversationId' => $conversationId,
            'tenantId' => $tenantId,
            ...$data,
        ]);
    }
}
