<?php

use Illuminate\Support\Facades\Route;
use Modules\WaoChat\Http\Controllers\RealtimeController;

/*
|--------------------------------------------------------------------------
| WaoChat API Routes
|--------------------------------------------------------------------------
|
| These routes are loaded by the WaoChatServiceProvider.
|
*/

Route::prefix('api/waochat')->group(function () {
    // Health check (public)
    Route::get('/health', [RealtimeController::class, 'health']);
});

Route::prefix('api/waochat')->middleware(['api', 'auth:sanctum'])->group(function () {
    // Token verification (called by Node.js)
    Route::post('/verify-token', [RealtimeController::class, 'verifyToken']);

    // Conversation access verification (called by Node.js)
    Route::post('/verify-access/{conversationId}', [RealtimeController::class, 'verifyAccess']);

    // Send message via WhatsApp (called by Node.js)
    Route::post('/send-message', [RealtimeController::class, 'sendMessage']);
});
