<?php $__env->startSection('page-title', 'Generate QR Codes'); ?>

<div class="p-6" wire:poll.2s="updateProgress">
    <div class="max-w-4xl mx-auto">

        
        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
            <div class="mb-6 p-4 bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 rounded-lg">
                <p class="text-sm text-green-700 dark:text-green-300"><?php echo e(session('message')); ?></p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        
        <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg overflow-hidden">
            <div class="p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-6">Generate QR Codes</h2>

                <form wire:submit="generateCodes" class="space-y-6">

                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Quantity to Generate
                        </label>
                        <div class="flex items-center gap-3">
                            <input
                                type="text"
                                wire:model="quantity"
                                readonly
                                class="w-48 px-4 py-2 text-center text-lg font-semibold border border-gray-300 dark:border-gray-600 rounded-lg bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100"
                            />
                            <button
                                type="button"
                                wire:click="decrement"
                                <?php if($isGenerating): ?> disabled <?php endif; ?>
                                class="px-4 py-2 bg-gray-500 hover:bg-gray-600 text-white font-bold rounded-lg disabled:opacity-50 disabled:cursor-not-allowed"
                            >
                                -
                            </button>
                            <button
                                type="button"
                                wire:click="increment"
                                <?php if($isGenerating): ?> disabled <?php endif; ?>
                                class="px-4 py-2 bg-gray-500 hover:bg-gray-600 text-white font-bold rounded-lg disabled:opacity-50 disabled:cursor-not-allowed"
                            >
                                +
                            </button>
                        </div>
                        <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">Min: 10,000 | Increment: +10,000</p>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-xs text-red-500 mt-1"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Starting Serial Number (Optional)
                        </label>
                        <input
                            type="number"
                            wire:model="startingSerial"
                            <?php if($isGenerating): ?> disabled <?php endif; ?>
                            class="w-48 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 disabled:opacity-50"
                            placeholder="100000"
                            min="0"
                        />
                        <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">Leave blank for auto-increment from last code</p>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['startingSerial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-xs text-red-500 mt-1"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    
                    <div>
                        <button
                            type="submit"
                            <?php if($isGenerating): ?> disabled <?php endif; ?>
                            class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed"
                        >
                            <!--[if BLOCK]><![endif]--><?php if($isGenerating): ?>
                                Generating...
                            <?php else: ?>
                                Generate Codes
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </button>
                    </div>

                </form>

            </div>
        </div>

        
        <!--[if BLOCK]><![endif]--><?php if($isGenerating || $progress > 0): ?>
            <div class="mt-6 bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg overflow-hidden">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Generation Progress</h3>

                    
                    <div class="mb-4">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-sm text-gray-600 dark:text-gray-300">
                                <?php echo e(number_format($progress)); ?> / <?php echo e(number_format($totalQuantity)); ?>

                            </span>
                            <span class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                <?php echo e($totalQuantity > 0 ? round(($progress / $totalQuantity) * 100) : 0); ?>%
                            </span>
                        </div>
                        <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-6 overflow-hidden">
                            <div
                                class="bg-blue-600 h-6 rounded-full transition-all duration-500 flex items-center justify-end pr-2"
                                style="width: <?php echo e($totalQuantity > 0 ? ($progress / $totalQuantity) * 100 : 0); ?>%"
                            >
                                <!--[if BLOCK]><![endif]--><?php if($progress > 0): ?>
                                    <span class="text-xs font-bold text-white">
                                        <?php echo e($totalQuantity > 0 ? round(($progress / $totalQuantity) * 100) : 0); ?>%
                                    </span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>

                    
                    <div class="space-y-2">
                        <!--[if BLOCK]><![endif]--><?php if($isGenerating): ?>
                            <div class="flex items-center gap-2 text-blue-600 dark:text-blue-400">
                                <svg class="animate-spin h-5 w-5" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                <span class="text-sm font-medium">Generating codes in batches of 1,000...</span>
                            </div>
                        <?php else: ?>
                            <div class="flex items-center gap-2 text-green-600 dark:text-green-400">
                                <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-sm font-medium">Generation complete!</span>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            Processing in batches of 1,000 codes for optimal performance
                        </div>

                        <!--[if BLOCK]><![endif]--><?php if($totalQuantity > 0): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400">
                                Estimated time: ~<?php echo e(ceil($totalQuantity / 1000)); ?> seconds
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    </div>
</div>
<?php /**PATH C:\laragon\www\trueid\resources\views/livewire/admin/qr-codes/generate.blade.php ENDPATH**/ ?>