<?php

use App\Livewire\Admin\Settings;
use App\Livewire\Admin\QrCodes\Index as QrCodesIndex;
use App\Livewire\Admin\QrCodes\Generate as QrCodesGenerate;
use App\Livewire\Admin\QrCodes\Import as QrCodesImport;
use App\Livewire\Public\CodeVerification;
use Illuminate\Support\Facades\Route;

// Public Routes
Route::get('/', CodeVerification::class)->name('home');
Route::get('/verify', CodeVerification::class)->name('verify');

// Authenticated Routes
Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

// Settings Route
Route::middleware(['auth'])->group(function () {
    Route::get('/settings', Settings::class)->name('settings');

    // QR Codes Routes
    Route::get('/qr-codes', QrCodesIndex::class)->name('qr-codes.index');
    Route::get('/qr-codes/generate', QrCodesGenerate::class)->name('qr-codes.generate');
    Route::get('/qr-codes/import', QrCodesImport::class)->name('qr-codes.import');
});

require __DIR__.'/auth.php';
