<div class="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 flex items-center justify-center py-6 px-3">
    <div class="w-full" style="max-width: 350px;">

        {{-- Logo Section --}}
        @if($siteConfig->logo)
            <div class="text-center mb-6">
                <img
                    src="{{ asset('storage/' . $siteConfig->logo) }}"
                    alt="{{ $siteConfig->name }}"
                    class="mx-auto"
                    style="max-width: {{ $siteConfig->width }}px; max-height: {{ $siteConfig->height }}px;"
                >
            </div>
        @else
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-900">
                    {{ $siteConfig->name ?? 'GB Secure' }}
                </h1>
            </div>
        @endif

        {{-- Main Card --}}
        <div class="bg-white rounded-xl shadow-lg p-4">

            {{-- Serial Number Display (if scanned) --}}
            @if($serial)
                <div class="text-center mb-3 p-2.5 bg-blue-50 rounded-lg">
                    <p class="text-xs text-gray-600 mb-1">Your product serial number is:</p>
                    <div class="text-lg font-bold text-blue-600 border-2 border-blue-400 rounded px-3 py-1.5 inline-block">
                        {{ $serial }}
                    </div>
                </div>
            @endif

            <h2 class="text-base font-bold text-center text-gray-800 mb-3">
                Product Checking
            </h2>

            {{-- QR Code Instruction Image --}}
            @if($siteConfig->contest && isset($siteConfig->contest['qr_sample']))
                <div class="mb-3 bg-gray-50 rounded-lg p-2.5 text-center">
                    <img
                        src="{{ asset('storage/' . $siteConfig->contest['qr_sample']) }}"
                        alt="QR Code Sample"
                        class="mx-auto max-w-full h-auto rounded"
                        style="max-height: 180px;"
                    >
                    <p class="text-xs text-gray-500 mt-1.5">Sample QR Code Instruction</p>
                </div>
            @endif

            {{-- Verification Form --}}
            <form wire:submit="verifyCode" class="space-y-3">

                {{-- Name Field --}}
                @php
                    $nameField = $customerFields->firstWhere('unique_key', 'name');
                @endphp
                @if($nameField && $nameField->visible)
                    <div>
                        <input
                            type="text"
                            wire:model="name"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2.5"
                            placeholder="{{ $nameField->placeholder }}{{ $nameField->required ? ' *' : '' }}"
                            {{ $nameField->required ? 'required' : '' }}
                        >
                        @error('name') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                    </div>
                @endif

                {{-- Email Field --}}
                @php
                    $emailField = $customerFields->firstWhere('unique_key', 'email');
                @endphp
                @if($emailField && $emailField->visible)
                    <div>
                        <input
                            type="email"
                            wire:model="email"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2.5"
                            placeholder="{{ $emailField->placeholder }}{{ $emailField->required ? ' *' : '' }}"
                            {{ $emailField->required ? 'required' : '' }}
                        >
                        @error('email') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                    </div>
                @endif

                {{-- Contact/Phone Field --}}
                @php
                    $contactField = $customerFields->firstWhere('unique_key', 'contact');
                @endphp
                @if($contactField && $contactField->visible)
                    <div>
                        <input
                            type="tel"
                            wire:model="contact"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2.5"
                            placeholder="{{ $contactField->placeholder }}{{ $contactField->required ? ' *' : '' }}"
                            {{ $contactField->required ? 'required' : '' }}
                        >
                        @error('contact') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                    </div>
                @endif

                {{-- Dynamic Extra Fields --}}
                @foreach($customerFields as $field)
                    @if(!in_array($field->unique_key, ['name', 'email', 'contact']) && $field->visible)
                        <div>
                            <input
                                type="text"
                                wire:model="extraFields.{{ $field->unique_key }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2.5"
                                placeholder="{{ $field->placeholder }}{{ $field->required ? ' *' : '' }}"
                                {{ $field->required ? 'required' : '' }}
                            >
                            @error('extraFields.' . $field->unique_key)
                                <span class="text-xs text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    @endif
                @endforeach

                {{-- Serial/Pincode Input (Always at bottom, always required) --}}
                <div>
                    <input
                        type="text"
                        wire:model="serial"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2.5"
                        placeholder="{{ $pincodePlaceholder }}"
                        required
                    >
                    @error('serial') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>

                {{-- Error Messages --}}
                @if($verificationResult && in_array($verificationResult['status'], ['error', 'warning']))
                    <div class="p-2.5 rounded-lg {{ $verificationResult['status'] === 'error' ? 'bg-red-50 border border-red-200' : 'bg-yellow-50 border border-yellow-200' }}">
                        <p class="text-xs {{ $verificationResult['status'] === 'error' ? 'text-red-700' : 'text-yellow-700' }}">
                            {{ $verificationResult['message'] }}
                        </p>
                    </div>
                @endif

                {{-- Verify Button --}}
                <div class="pt-3">
                    <button
                        type="submit"
                        wire:loading.attr="disabled"
                        class="w-full bg-gradient-to-r from-blue-500 to-cyan-400 text-white py-3 rounded-lg font-bold text-base
                               hover:from-blue-600 hover:to-cyan-500 focus:outline-none focus:ring-2 focus:ring-blue-500
                               disabled:opacity-50 disabled:cursor-not-allowed transition-all duration-200 shadow-lg"
                    >
                        <span wire:loading.remove wire:target="verifyCode">VERIFY</span>
                        <span wire:loading wire:target="verifyCode" class="flex items-center justify-center">
                            <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            Verifying...
                        </span>
                    </button>
                </div>
            </form>
        </div>

        {{-- Footer --}}
        <div class="text-center mt-4">
            <p class="text-xs text-gray-600">
                © {{ date('Y') }} {{ $siteConfig->name ?? 'GB Secure' }}
            </p>
        </div>
    </div>

    {{-- Success Modal --}}
    @if($showSuccessModal)
        <div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4 z-50" wire:click.self="closeModal">
            <div class="bg-white rounded-xl shadow-2xl w-full animate-fade-in" style="max-width: 350px; max-height: 90vh; overflow-y-auto;">

                {{-- Modal Header --}}
                <div class="bg-gradient-to-r from-green-500 to-emerald-400 text-white p-4 rounded-t-xl relative">
                    <button wire:click="closeModal" class="absolute top-3 right-3 text-white hover:text-gray-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                    <div class="text-center">
                        <svg class="w-12 h-12 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <h3 class="text-lg font-bold">
                            @if($verificationResult['is_lucky'])
                                🎉 Congratulations! 🎉
                            @else
                                ✓ Verification Success!
                            @endif
                        </h3>
                    </div>
                </div>

                {{-- Modal Body --}}
                <div class="p-5 space-y-4">

                    {{-- Success Message --}}
                    <div class="text-center">
                        <p class="text-sm text-gray-700 mb-2">
                            Your product has been successfully verified!
                        </p>
                        @if($verificationResult['code'] && $verificationResult['code']->product)
                            <div class="bg-gray-50 rounded-lg p-3 text-left">
                                <p class="text-xs font-semibold text-gray-800 mb-1">Product Details:</p>
                                <p class="text-xs text-gray-600"><strong>Name:</strong> {{ $verificationResult['code']->product->name }}</p>
                                <p class="text-xs text-gray-600"><strong>SKU:</strong> {{ $verificationResult['code']->product->sku }}</p>
                            </div>
                        @endif
                    </div>

                    {{-- Lucky Draw Section --}}
                    @if($verificationResult['is_lucky'])
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                            <p class="text-xs font-bold text-yellow-800 mb-2">🎁 You're a Lucky Winner!</p>
                            <p class="text-xs text-yellow-700">
                                {{ $siteConfig->descr ?? 'Congratulations! You have won our lucky draw. Please follow the instructions below to claim your prize.' }}
                            </p>
                        </div>

                        {{-- Image Upload for Prize Claim --}}
                        <div>
                            <label class="block text-xs font-semibold text-gray-700 mb-2">
                                Upload Receipt/Product Photo (Optional)
                            </label>
                            <input
                                type="file"
                                wire:model="prizeImage"
                                accept="image/*"
                                class="w-full text-xs border border-gray-300 rounded-lg p-2"
                            >
                            @error('prizeImage')
                                <span class="text-xs text-red-500">{{ $message }}</span>
                            @enderror

                            @if($prizeImage)
                                <div class="mt-2">
                                    <button
                                        wire:click="uploadPrizeImage"
                                        class="w-full bg-green-500 text-white text-xs py-2 rounded-lg hover:bg-green-600"
                                    >
                                        Upload Image
                                    </button>
                                </div>
                            @endif

                            @if(session()->has('imageUploaded'))
                                <p class="text-xs text-green-600 mt-1">{{ session('imageUploaded') }}</p>
                            @endif

                            <div wire:loading wire:target="prizeImage" class="text-xs text-blue-600 mt-1">
                                Loading image...
                            </div>
                        </div>

                        {{-- Reward Instructions --}}
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                            <p class="text-xs font-semibold text-blue-800 mb-1">How to Collect Your Reward:</p>
                            <ol class="text-xs text-blue-700 space-y-1 list-decimal list-inside">
                                <li>Contact us via WhatsApp button below</li>
                                <li>Provide your verification code: <strong>{{ $serial }}</strong></li>
                                <li>Upload your product photo if required</li>
                                <li>Our team will contact you for prize collection</li>
                            </ol>
                        </div>
                    @endif

                    {{-- Action Buttons --}}
                    <div class="space-y-2">
                        {{-- WhatsApp Button --}}
                        @if($siteConfig->contest && isset($siteConfig->contest['whatsapp']))
                            <a
                                href="https://wa.me/{{ str_replace(['+', ' ', '-'], '', $siteConfig->contest['whatsapp']) }}?text=Hello, I have verified my product with code: {{ $serial }}"
                                target="_blank"
                                class="w-full bg-green-500 hover:bg-green-600 text-white text-sm font-semibold py-3 rounded-lg flex items-center justify-center gap-2 transition-colors"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                                </svg>
                                Contact via WhatsApp
                            </a>
                        @endif

                        {{-- Contact Support Button --}}
                        <a
                            href="mailto:{{ $siteConfig->email ?? 'info@gbsecure.com' }}?subject=Product Verification Support&body=Serial: {{ $serial }}"
                            class="w-full bg-blue-500 hover:bg-blue-600 text-white text-sm font-semibold py-3 rounded-lg flex items-center justify-center gap-2 transition-colors"
                        >
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            Contact Support
                        </a>

                        {{-- Close Button --}}
                        <button
                            wire:click="closeModal"
                            class="w-full bg-gray-200 hover:bg-gray-300 text-gray-800 text-sm font-semibold py-3 rounded-lg transition-colors"
                        >
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{-- Animations --}}
    <style>
        @keyframes fade-in {
            from {
                opacity: 0;
                transform: scale(0.95);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
    </style>
</div>
