@section('page-title', 'Customer Form Field Settings')

<div class="p-6">
    <div class="max-w-7xl mx-auto">

        {{-- Header --}}
        <div class="mb-6">
            <p class="text-gray-600 dark:text-gray-300">Enable or disable fields that appear on the product verification form.</p>
        </div>

        {{-- Success Message --}}
        @if (session()->has('message'))
            <div class="mb-6 p-4 bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 rounded-lg">
                <p class="text-sm text-green-700 dark:text-green-300">{{ session('message') }}</p>
            </div>
        @endif

        <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg overflow-hidden">
            <div class="p-6">

            {{-- Fields Table --}}
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                Field Name
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                Placeholder
                            </th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                Visible
                            </th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                Required
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach($fields as $field)
                            <tr class="{{ in_array($field['unique_key'], ['name', 'email', 'contact']) ? 'bg-blue-50 dark:bg-blue-900/20' : '' }}">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="text-sm font-medium text-gray-900 dark:text-gray-100">
                                            {{ $field['name'] }}
                                        </div>
                                        @if(in_array($field['unique_key'], ['name', 'email', 'contact']))
                                            <span class="ml-2 px-2 py-1 text-xs font-semibold text-blue-800 dark:text-blue-300 bg-blue-200 dark:bg-blue-900/50 rounded-full">
                                                Base Field
                                            </span>
                                        @endif
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">{{ $field['unique_key'] }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    @if($editingPlaceholder === $field['id'])
                                        <div class="flex items-center gap-2">
                                            <input
                                                type="text"
                                                wire:model="placeholderValue"
                                                wire:keydown.enter="updatePlaceholder({{ $field['id'] }})"
                                                wire:keydown.escape="cancelEdit"
                                                class="text-sm px-2 py-1 border border-blue-500 rounded focus:outline-none focus:ring-2 focus:ring-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100"
                                                autofocus
                                            />
                                            <button
                                                wire:click="updatePlaceholder({{ $field['id'] }})"
                                                class="px-2 py-1 text-xs bg-green-500 text-white rounded hover:bg-green-600"
                                            >
                                                Save
                                            </button>
                                            <button
                                                wire:click="cancelEdit"
                                                class="px-2 py-1 text-xs bg-gray-500 text-white rounded hover:bg-gray-600"
                                            >
                                                Cancel
                                            </button>
                                        </div>
                                    @else
                                        <div class="flex items-center gap-2">
                                            <span class="text-sm text-gray-600 dark:text-gray-300">{{ $field['placeholder'] }}</span>
                                            <button
                                                wire:click="editPlaceholder({{ $field['id'] }}, '{{ addslashes($field['placeholder']) }}')"
                                                class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300"
                                                title="Edit placeholder"
                                            >
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <button
                                        wire:click.prevent="toggleVisible({{ $field['id'] }})"
                                        type="button"
                                        class="relative inline-flex items-center justify-center h-8 w-14 flex-shrink-0 cursor-pointer rounded-full transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-offset-2 {{ $field['visible'] ? 'bg-green-500 focus:ring-green-500' : 'bg-gray-300 dark:bg-gray-600 focus:ring-gray-400' }}"
                                        role="switch"
                                        aria-checked="{{ $field['visible'] ? 'true' : 'false' }}"
                                    >
                                        <span class="sr-only">Toggle visible</span>
                                        <span
                                            aria-hidden="true"
                                            class="absolute inline-block h-6 w-6 transform rounded-full bg-white shadow-lg ring-0 transition duration-200 ease-in-out {{ $field['visible'] ? 'translate-x-3' : '-translate-x-3' }}"
                                        ></span>
                                    </button>
                                    <div class="text-xs mt-1 font-medium {{ $field['visible'] ? 'text-green-600 dark:text-green-400' : 'text-gray-500 dark:text-gray-400' }}">
                                        {{ $field['visible'] ? 'ON' : 'OFF' }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <button
                                        wire:click.prevent="toggleRequired({{ $field['id'] }})"
                                        type="button"
                                        class="relative inline-flex items-center justify-center h-8 w-14 flex-shrink-0 cursor-pointer rounded-full transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-offset-2 {{ $field['required'] ? 'bg-blue-500 focus:ring-blue-500' : 'bg-gray-300 dark:bg-gray-600 focus:ring-gray-400' }}"
                                        role="switch"
                                        aria-checked="{{ $field['required'] ? 'true' : 'false' }}"
                                    >
                                        <span class="sr-only">Toggle required</span>
                                        <span
                                            aria-hidden="true"
                                            class="absolute inline-block h-6 w-6 transform rounded-full bg-white shadow-lg ring-0 transition duration-200 ease-in-out {{ $field['required'] ? 'translate-x-3' : '-translate-x-3' }}"
                                        ></span>
                                    </button>
                                    <div class="text-xs mt-1 font-medium {{ $field['required'] ? 'text-blue-600 dark:text-blue-400' : 'text-gray-500 dark:text-gray-400' }}">
                                        {{ $field['required'] ? 'ON' : 'OFF' }}
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        {{-- Pincode Field (Special Row - Always Required) --}}
                        <tr class="bg-blue-50 dark:bg-blue-900/30 border-t-2 border-blue-200 dark:border-blue-800">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="text-sm font-medium text-gray-900 dark:text-gray-100">
                                        {{ $pincodeField['name'] }}
                                    </div>
                                    <span class="ml-2 px-2 py-1 text-xs font-semibold text-blue-800 dark:text-blue-300 bg-blue-200 dark:bg-blue-900/50 rounded-full">
                                        Always Required
                                    </span>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">{{ $pincodeField['unique_key'] }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @if($editingPlaceholder === $pincodeField['id'])
                                    <div class="flex items-center gap-2">
                                        <input
                                            type="text"
                                            wire:model="placeholderValue"
                                            wire:keydown.enter="updatePlaceholder({{ $pincodeField['id'] }})"
                                            wire:keydown.escape="cancelEdit"
                                            class="text-sm px-2 py-1 border border-blue-500 rounded focus:outline-none focus:ring-2 focus:ring-blue-500 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100"
                                            autofocus
                                        />
                                        <button
                                            wire:click="updatePlaceholder({{ $pincodeField['id'] }})"
                                            class="px-2 py-1 text-xs bg-green-500 text-white rounded hover:bg-green-600"
                                        >
                                            Save
                                        </button>
                                        <button
                                            wire:click="cancelEdit"
                                            class="px-2 py-1 text-xs bg-gray-500 text-white rounded hover:bg-gray-600"
                                        >
                                            Cancel
                                        </button>
                                    </div>
                                @else
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm text-gray-600 dark:text-gray-300">{{ $pincodeField['placeholder'] }}</span>
                                        <button
                                            wire:click="editPlaceholder({{ $pincodeField['id'] }}, '{{ addslashes($pincodeField['placeholder']) }}')"
                                            class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300"
                                            title="Edit placeholder"
                                        >
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                            </svg>
                                        </button>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <div class="inline-flex items-center justify-center h-8 w-14 flex-shrink-0 rounded-full bg-gray-200 dark:bg-gray-700 opacity-50 cursor-not-allowed">
                                    <span class="inline-block h-6 w-6 rounded-full bg-gray-400 dark:bg-gray-600 shadow-lg"></span>
                                </div>
                                <div class="text-xs mt-1 font-medium text-gray-400 dark:text-gray-500">
                                    Always ON
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <div class="inline-flex items-center justify-center h-8 w-14 flex-shrink-0 rounded-full bg-gray-200 dark:bg-gray-700 opacity-50 cursor-not-allowed">
                                    <span class="inline-block h-6 w-6 rounded-full bg-gray-400 dark:bg-gray-600 shadow-lg"></span>
                                </div>
                                <div class="text-xs mt-1 font-medium text-gray-400 dark:text-gray-500">
                                    Always ON
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            </div>
        </div>

    </div>
</div>
