@section('page-title', 'Import QR Codes')

<div class="p-6">
    <div class="max-w-4xl mx-auto">

        {{-- Success Message --}}
        @if (session()->has('message'))
            <div class="mb-6 p-4 bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 rounded-lg">
                <p class="text-sm text-green-700 dark:text-green-300">{{ session('message') }}</p>
            </div>
        @endif

        {{-- Error Message --}}
        @if (session()->has('error'))
            <div class="mb-6 p-4 bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-800 rounded-lg">
                <p class="text-sm text-red-700 dark:text-red-300">{{ session('error') }}</p>
            </div>
        @endif

        {{-- Import Form --}}
        <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg overflow-hidden">
            <div class="p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-6">Import QR Codes from CSV</h2>

                <form wire:submit="importCodes" class="space-y-6">

                    {{-- File Upload --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Upload CSV file (supports both old and new formats)
                        </label>
                        <input
                            type="file"
                            wire:model="csvFile"
                            accept=".csv,.txt"
                            @if($isImporting) disabled @endif
                            class="block w-full text-sm text-gray-900 dark:text-gray-100 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none disabled:opacity-50"
                        />
                        @error('csvFile') <span class="text-xs text-red-500 mt-1">{{ $message }}</span> @enderror

                        @if($csvFile)
                            <p class="mt-2 text-xs text-green-600 dark:text-green-400">
                                File selected: {{ $csvFile->getClientOriginalName() }} ({{ number_format($csvFile->getSize() / 1024, 2) }} KB)
                            </p>
                        @endif
                    </div>

                    {{-- CSV Format Info --}}
                    <div class="p-4 bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-800 rounded-lg">
                        <h3 class="text-sm font-semibold text-blue-900 dark:text-blue-300 mb-2">CSV Format Supported:</h3>
                        <div class="text-xs text-blue-800 dark:text-blue-300 space-y-2">
                            <p><strong>Supports both old and new formats:</strong></p>
                            <ul class="list-disc ml-4 space-y-1">
                                <li><strong>Old format:</strong> guid, qr, status, islucky, lastverified, attempts</li>
                                <li><strong>New format:</strong> serial, qr_pin, status, is_lucky, used_at, attempts</li>
                            </ul>
                            <p class="mt-2"><strong>Required columns:</strong> Must have either (guid + qr) OR (serial + qr_pin)</p>
                            <p class="mt-2"><strong>Optional columns:</strong> status, used_at, is_lucky, attempts</p>
                            <p><strong>Example (new format):</strong></p>
                            <code class="block bg-white dark:bg-gray-800 p-2 rounded mt-1 font-mono">
                                serial,qr_pin,status,is_lucky,attempts<br/>
                                0103,D3W3ODUC,used,0,3<br/>
                                0109,5UVQ3O27,unused,1,0
                            </code>
                        </div>
                    </div>

                    {{-- Import Button --}}
                    <div>
                        <button
                            type="submit"
                            @if($isImporting || !$csvFile) disabled @endif
                            class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed"
                        >
                            @if($isImporting)
                                Importing...
                            @else
                                Import Codes
                            @endif
                        </button>

                        @if($importComplete)
                            <button
                                type="button"
                                wire:click="resetImport"
                                class="ml-3 px-6 py-3 bg-gray-500 hover:bg-gray-600 text-white font-semibold rounded-lg transition-colors"
                            >
                                Import Another File
                            </button>
                        @endif
                    </div>

                </form>

            </div>
        </div>

        {{-- Progress Section --}}
        @if($isImporting || $importComplete)
            <div class="mt-6 bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg overflow-hidden">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Import Progress</h3>

                    {{-- Progress Bar --}}
                    <div class="mb-4">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-sm text-gray-600 dark:text-gray-300">
                                {{ number_format($importProgress) }} / {{ number_format($importTotal) }}
                            </span>
                            <span class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                {{ $importTotal > 0 ? round(($importProgress / $importTotal) * 100) : 0 }}%
                            </span>
                        </div>
                        <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-6 overflow-hidden">
                            <div
                                class="bg-green-600 h-6 rounded-full transition-all duration-500 flex items-center justify-end pr-2"
                                style="width: {{ $importTotal > 0 ? ($importProgress / $importTotal) * 100 : 0 }}%"
                            >
                                @if($importProgress > 0)
                                    <span class="text-xs font-bold text-white">
                                        {{ $importTotal > 0 ? round(($importProgress / $importTotal) * 100) : 0 }}%
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Results --}}
                    @if($importComplete)
                        <div class="space-y-2">
                            <h4 class="text-sm font-semibold text-gray-900 dark:text-gray-100">Results:</h4>
                            <div class="flex items-center gap-2 text-green-600 dark:text-green-400">
                                <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-sm font-medium">Successfully imported: {{ number_format($importedCount) }} codes</span>
                            </div>
                            @if($skippedCount > 0)
                                <div class="flex items-center gap-2 text-yellow-600 dark:text-yellow-400">
                                    <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                    </svg>
                                    <span class="text-sm font-medium">Skipped duplicates: {{ number_format($skippedCount) }} codes</span>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="flex items-center gap-2 text-blue-600 dark:text-blue-400">
                            <svg class="animate-spin h-5 w-5" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <span class="text-sm font-medium">Importing codes from CSV...</span>
                        </div>
                    @endif

                </div>
            </div>
        @endif

    </div>
</div>
