<!-- Sidebar Navigation -->
<aside class="fixed top-0 left-0 z-40 w-64 h-screen bg-gray-800 dark:bg-gray-900 transition-transform -translate-x-full sm:translate-x-0">
    <div class="h-full px-3 py-4 overflow-y-auto">

        {{-- Logo --}}
        <div class="flex items-center mb-5 px-3">
            <span class="text-2xl font-bold text-white">TrueID</span>
        </div>

        {{-- Navigation Items --}}
        <ul class="space-y-2 font-medium">

            {{-- Dashboard --}}
            <li>
                <a href="{{ route('dashboard') }}"
                   class="flex items-center p-2 text-gray-300 rounded-lg hover:bg-gray-700 {{ request()->routeIs('dashboard') ? 'bg-gray-700 text-white' : '' }}">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
                    </svg>
                    <span class="ml-3">Dashboard</span>
                </a>
            </li>

            {{-- QR Codes --}}
            <li x-data="{ qrCodesOpen: {{ request()->routeIs('qr-codes.*') ? 'true' : 'false' }} }">
                <button type="button"
                        class="flex items-center w-full p-2 text-gray-300 rounded-lg hover:bg-gray-700"
                        @click="qrCodesOpen = !qrCodesOpen">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h3a1 1 0 011 1v3a1 1 0 01-1 1H4a1 1 0 01-1-1V4zm2 2V5h1v1H5zM3 13a1 1 0 011-1h3a1 1 0 011 1v3a1 1 0 01-1 1H4a1 1 0 01-1-1v-3zm2 2v-1h1v1H5zM13 3a1 1 0 00-1 1v3a1 1 0 001 1h3a1 1 0 001-1V4a1 1 0 00-1-1h-3zm1 2v1h1V5h-1z" clip-rule="evenodd"></path>
                        <path d="M11 4a1 1 0 10-2 0v1a1 1 0 002 0V4zM10 7a1 1 0 011 1v1h2a1 1 0 110 2h-3a1 1 0 01-1-1V8a1 1 0 011-1zM16 9a1 1 0 100 2 1 1 0 000-2zM9 13a1 1 0 011-1h1a1 1 0 110 2v2a1 1 0 11-2 0v-3zM7 11a1 1 0 100-2H4a1 1 0 100 2h3zM17 13a1 1 0 01-1 1h-2a1 1 0 110-2h2a1 1 0 011 1zM16 17a1 1 0 100-2h-3a1 1 0 100 2h3z"></path>
                    </svg>
                    <span class="flex-1 ml-3 text-left whitespace-nowrap">QR Codes</span>
                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
                <ul x-show="qrCodesOpen" class="py-2 space-y-2 pl-11" x-transition>
                    <li>
                        <a href="{{ route('qr-codes.index') }}" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm {{ request()->routeIs('qr-codes.index') ? 'bg-gray-700 text-white' : '' }}">All Codes View</a>
                    </li>
                    <li>
                        <a href="{{ route('qr-codes.generate') }}" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm {{ request()->routeIs('qr-codes.generate') ? 'bg-gray-700 text-white' : '' }}">Generate Codes</a>
                    </li>
                    <li>
                        <a href="{{ route('qr-codes.import') }}" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm {{ request()->routeIs('qr-codes.import') ? 'bg-gray-700 text-white' : '' }}">Import Codes</a>
                    </li>
                </ul>
            </li>

            {{-- Products --}}
            <li x-data="{ productsOpen: false }">
                <button type="button"
                        class="flex items-center w-full p-2 text-gray-300 rounded-lg hover:bg-gray-700"
                        @click="productsOpen = !productsOpen">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"></path>
                    </svg>
                    <span class="flex-1 ml-3 text-left whitespace-nowrap">Products</span>
                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
                <ul x-show="productsOpen" class="py-2 space-y-2 pl-11" x-transition>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">Add Product</a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">View Products</a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">Tagging Products</a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">Un-tag Products</a>
                    </li>
                </ul>
            </li>

            {{-- Resellers --}}
            <li x-data="{ resellersOpen: false }">
                <button type="button"
                        class="flex items-center w-full p-2 text-gray-300 rounded-lg hover:bg-gray-700"
                        @click="resellersOpen = !resellersOpen">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3zM6 8a2 2 0 11-4 0 2 2 0 014 0zM16 18v-3a5.972 5.972 0 00-.75-2.906A3.005 3.005 0 0119 15v3h-3zM4.75 12.094A5.973 5.973 0 004 15v3H1v-3a3 3 0 013.75-2.906z"></path>
                    </svg>
                    <span class="flex-1 ml-3 text-left whitespace-nowrap">Resellers</span>
                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
                <ul x-show="resellersOpen" class="py-2 space-y-2 pl-11" x-transition>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">Add Reseller</a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">View Resellers</a>
                    </li>
                </ul>
            </li>

            {{-- Agents --}}
            <li x-data="{ agentsOpen: false }">
                <button type="button"
                        class="flex items-center w-full p-2 text-gray-300 rounded-lg hover:bg-gray-700"
                        @click="agentsOpen = !agentsOpen">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"></path>
                    </svg>
                    <span class="flex-1 ml-3 text-left whitespace-nowrap">Agents</span>
                    <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
                <ul x-show="agentsOpen" class="py-2 space-y-2 pl-11" x-transition>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">Add Agent</a>
                    </li>
                    <li>
                        <a href="#" class="flex items-center p-2 text-gray-400 rounded-lg hover:bg-gray-700 text-sm">View Agents</a>
                    </li>
                </ul>
            </li>

            {{-- Customer Database --}}
            <li>
                <a href="#"
                   class="flex items-center p-2 text-gray-300 rounded-lg hover:bg-gray-700">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z"></path>
                        <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-3">Customer Database</span>
                </a>
            </li>

            {{-- Lucky QR Codes --}}
            <li>
                <a href="#"
                   class="flex items-center p-2 text-gray-300 rounded-lg hover:bg-gray-700">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5 2a1 1 0 011 1v1h1a1 1 0 010 2H6v1a1 1 0 01-2 0V6H3a1 1 0 010-2h1V3a1 1 0 011-1zm0 10a1 1 0 011 1v1h1a1 1 0 110 2H6v1a1 1 0 11-2 0v-1H3a1 1 0 110-2h1v-1a1 1 0 011-1zM12 2a1 1 0 01.967.744L14.146 7.2 17.5 9.134a1 1 0 010 1.732l-3.354 1.935-1.18 4.455a1 1 0 01-1.933 0L9.854 12.8 6.5 10.866a1 1 0 010-1.732l3.354-1.935 1.18-4.455A1 1 0 0112 2z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-3">Lucky QR Codes</span>
                </a>
            </li>

            {{-- Assign Reseller/Agent --}}
            <li>
                <a href="#"
                   class="flex items-center p-2 text-gray-300 rounded-lg hover:bg-gray-700">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-3">Assign Reseller/Agent</span>
                </a>
            </li>

            {{-- Divider --}}
            <li class="pt-4 mt-4 border-t border-gray-700">
                <a href="{{ route('settings') }}"
                   class="flex items-center p-2 text-gray-300 rounded-lg hover:bg-gray-700 {{ request()->routeIs('settings') ? 'bg-gray-700 text-white' : '' }}">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-3">Settings</span>
                </a>
            </li>

        </ul>
    </div>
</aside>
