<?php

namespace Database\Seeders;

use App\Models\Site;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SiteConfigSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Site::firstOrCreate(
            ['id' => 1],
            [
                'name' => 'GB Secure',
                'descr' => 'Verify the authenticity of your product by scanning the QR code or entering the serial number below. Our advanced hologram security system ensures your product is genuine and protected against counterfeits.',
                'logo' => 'logo.png',
                'width' => 200,
                'height' => 80,
                'email' => 'info@gbsecure.com',
                'customer_response' => Site::CUSTOMER_RESPONSE_AFTER, // 2 = After serial verification
                'contest' => [
                    'images' => [],
                    'styles' => [
                        'primaryColor' => '#3b82f6',
                        'secondaryColor' => '#6366f1',
                        'footerBgColor' => '#f8f9fa',
                    ],
                    'qr_sample' => 'hologram_sample.png',
                    'whatsapp' => '+60123456789',
                ],
            ]
        );

        $this->command->info('Site configuration created successfully!');
        $this->command->info('Site Name: GB Secure');
        $this->command->info('Customer Response Mode: After Serial (Lucky Draw)');
    }
}
