<?php

namespace Database\Seeders;

use App\Models\CustomerField;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DefaultCustomerFieldsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $fields = [
            // Base fields (required, cannot be deleted)
            [
                'unique_key' => 'name',
                'name' => 'Full Name',
                'placeholder' => 'Enter your full name',
                'required' => true,
                'visible' => true,
            ],
            [
                'unique_key' => 'email',
                'name' => 'Email Address',
                'placeholder' => 'Enter your email address',
                'required' => true,
                'visible' => true,
            ],
            [
                'unique_key' => 'contact',
                'name' => 'Contact Number',
                'placeholder' => 'Enter your phone number',
                'required' => true,
                'visible' => true,
            ],

            // Optional custom fields
            [
                'unique_key' => 'address',
                'name' => 'Address',
                'placeholder' => 'Enter your address',
                'required' => false,
                'visible' => true,
            ],
            [
                'unique_key' => 'city',
                'name' => 'City',
                'placeholder' => 'Enter your city',
                'required' => false,
                'visible' => true,
            ],
            [
                'unique_key' => 'state',
                'name' => 'State',
                'placeholder' => 'Enter your state',
                'required' => false,
                'visible' => true,
            ],
            [
                'unique_key' => 'postcode',
                'name' => 'Postcode',
                'placeholder' => 'Enter your postcode',
                'required' => false,
                'visible' => true,
            ],
        ];

        foreach ($fields as $field) {
            CustomerField::firstOrCreate(
                ['unique_key' => $field['unique_key']],
                $field
            );
        }

        $this->command->info('Default customer fields created successfully!');
    }
}
