<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default admin user
        User::firstOrCreate(
            ['email' => 'admin@gbsecure.com'],
            [
                'firstname' => 'Admin',
                'lastname' => 'User',
                'email' => 'admin@gbsecure.com',
                'password' => Hash::make('password'),
                'role' => 'admin',
                'status' => 'active',
                'secure' => true,
                'phonenumber' => '+60123456789',
                'address' => 'GB Secure Headquarters',
                'region' => 'Kuala Lumpur',
            ]
        );

        // Create a test manager user
        User::firstOrCreate(
            ['email' => 'manager@gbsecure.com'],
            [
                'firstname' => 'Manager',
                'lastname' => 'Test',
                'email' => 'manager@gbsecure.com',
                'password' => Hash::make('password'),
                'role' => 'manager',
                'status' => 'active',
                'secure' => true,
                'phonenumber' => '+60123456790',
                'address' => 'GB Secure Branch Office',
                'region' => 'Selangor',
            ]
        );

        $this->command->info('Admin and Manager users created successfully!');
        $this->command->info('Admin Email: admin@gbsecure.com | Password: password');
        $this->command->info('Manager Email: manager@gbsecure.com | Password: password');
    }
}
