<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('qr_codes', function (Blueprint $table) {
            $table->integer('attempts')->default(0)->after('is_lucky')
                  ->comment('Number of verification attempts');

            // Add index for performance when filtering/sorting by attempts
            $table->index('attempts');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('qr_codes', function (Blueprint $table) {
            $table->dropIndex(['attempts']);
            $table->dropColumn('attempts');
        });
    }
};
