<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qr_codes', function (Blueprint $table) {
            $table->id();
            $table->string('serial', 20)->unique();
            $table->string('qr_pin', 8)->unique();
            $table->enum('status', ['unused', 'used'])->default('unused');
            $table->timestamp('used_at')->nullable();
            $table->unsignedBigInteger('assigned_to_id')->nullable();
            $table->string('assigned_to_type', 50)->nullable();
            $table->timestamp('last_exported_at')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->boolean('is_lucky')->default(false);
            $table->string('batch_id', 50)->nullable();
            $table->timestamps();

            // Indexes for performance
            $table->index('serial');
            $table->index('qr_pin');
            $table->index('status');
            $table->index('is_lucky');
            $table->index('batch_id');
            $table->index('assigned_to_id');
            $table->index('product_id');
            $table->index('created_at');

            // Composite indexes for common queries
            $table->index(['status', 'is_lucky', 'created_at'], 'status_lucky_created_idx');
            $table->index(['serial', 'status'], 'serial_status_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('qr_codes');
    }
};
