<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sites', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);
            $table->text('descr')->comment('Instructions text');
            $table->text('logo')->nullable();
            $table->integer('width')->default(150);
            $table->integer('height')->default(150);
            $table->string('email');
            $table->tinyInteger('customer_response')->default(0)->comment('0=None, 1=Before, 2=After serial');
            $table->json('contest')->nullable()->comment('Contest styling & images');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sites');
    }
};
