<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('contact');
            $table->string('email');
            $table->string('serial', 50)->comment('QR code verified');
            $table->json('extra_fields')->nullable()->comment('Dynamic custom fields');
            $table->boolean('is_lucky_draw')->default(false);
            $table->timestamps();

            $table->index('serial');
            $table->index('is_lucky_draw');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
