<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sellers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('owner_id')->nullable()->constrained('users')->nullOnDelete()->comment('Manager who owns this seller');
            $table->string('fname', 100);
            $table->string('lname', 100);
            $table->string('email', 100)->unique();
            $table->string('address')->nullable();
            $table->string('region', 100)->nullable();
            $table->string('phone', 50)->nullable();
            $table->boolean('status')->default(true)->comment('Active/Inactive');
            $table->enum('type', ['reseller', 'agent'])->default('reseller');
            $table->timestamps();

            $table->index(['type', 'status']);
            $table->index('owner_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sellers');
    }
};
