<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codes', function (Blueprint $table) {
            $table->id();
            $table->string('guid', 50)->unique();
            $table->string('qr', 50)->unique();
            $table->enum('status', ['unused', 'used', 'fake'])->default('unused');
            $table->boolean('islucky')->default(false);
            $table->date('exported')->nullable();
            $table->date('lastverified')->nullable();
            $table->string('ipv')->nullable()->comment('IP address of verifier');
            $table->unsignedBigInteger('product_id')->nullable();
            $table->integer('attempts')->default(0)->comment('Verification attempt count');
            $table->timestamps();

            $table->index(['guid', 'qr']);
            $table->index(['status', 'islucky']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codes');
    }
};
