<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Site extends Model
{
    protected $fillable = [
        'name',
        'descr',
        'logo',
        'width',
        'height',
        'email',
        'customer_response',
        'contest',
    ];

    protected $casts = [
        'width' => 'integer',
        'height' => 'integer',
        'customer_response' => 'integer',
        'contest' => 'array',
    ];

    /**
     * Customer response modes
     */
    public const CUSTOMER_RESPONSE_NONE = 0;
    public const CUSTOMER_RESPONSE_BEFORE = 1;
    public const CUSTOMER_RESPONSE_AFTER = 2;

    /**
     * Get singleton instance
     */
    public static function config()
    {
        return static::first() ?? new static();
    }
}
