<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Product extends Model
{
    protected $fillable = [
        'name',
        'code',
        'kkm',
        'sku',
        'halal_status',
        'manufacture_dt',
        'expiry_dt',
    ];

    protected $casts = [
        'halal_status' => 'date',
        'manufacture_dt' => 'date',
        'expiry_dt' => 'date',
    ];

    /**
     * Get codes associated with this product
     */
    public function codes(): HasMany
    {
        return $this->hasMany(Code::class);
    }

    /**
     * Scope to get products with active codes
     */
    public function scopeWithActiveCodes($query)
    {
        return $query->whereHas('codes', function ($q) {
            $q->where('status', 'unused');
        });
    }
}
