<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomerField extends Model
{
    protected $fillable = [
        'unique_key',
        'name',
        'placeholder',
        'required',
        'visible',
    ];

    protected $casts = [
        'required' => 'boolean',
        'visible' => 'boolean',
    ];

    /**
     * Base fields that cannot be deleted
     */
    public const BASE_FIELDS = ['name', 'email', 'contact'];

    /**
     * Check if this is a base field
     */
    public function isBaseField(): bool
    {
        return in_array($this->unique_key, self::BASE_FIELDS);
    }

    /**
     * Scope to get visible fields only
     */
    public function scopeVisible($query)
    {
        return $query->where('visible', true);
    }

    /**
     * Scope to get required fields
     */
    public function scopeRequired($query)
    {
        return $query->where('required', true);
    }
}
