<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Customer extends Model
{
    protected $fillable = [
        'name',
        'contact',
        'email',
        'serial',
        'extra_fields',
        'is_lucky_draw',
    ];

    protected $casts = [
        'extra_fields' => 'array',
        'is_lucky_draw' => 'boolean',
    ];

    /**
     * Get the code that was verified
     */
    public function code(): BelongsTo
    {
        return $this->belongsTo(Code::class, 'serial', 'qr');
    }

    /**
     * Scope to get lucky draw submissions
     */
    public function scopeLuckyDraw($query)
    {
        return $query->where('is_lucky_draw', true);
    }
}
