# TrueID - GB Secure TALL Stack Rebuild

## Project Overview

**TrueID** is the modern rebuild of the GB Secure (Gengbiz Hologram Security Sticker System) using the latest TALL stack technologies.

### Original System
- **Framework:** CodeIgniter 4
- **Location:** `C:\laragon\www\holobit`
- **Backup:** `C:\laragon\www\holobit_backup_[timestamp]`
- **Documentation:** `C:\laragon\www\holobit\DOCUMENTATION.md`

### New System (This Project)
- **Framework:** Laravel 12
- **Stack:** TALL (Tailwind, Alpine.js, Laravel, Livewire)
- **Location:** `C:\laragon\www\trueid`
- **Database:** MySQL (trueid)

---

## Technology Stack - Latest Versions Installed

### TALL Stack Components

```
Laravel 12.36.1      - PHP Framework (Backend)
Livewire 3.6.4       - Full-stack framework for dynamic UIs
Livewire Volt 1.8.0  - Single-file Livewire components
Alpine.js 3.x        - Lightweight JavaScript framework
Tailwind CSS 3.x     - Utility-first CSS framework
Vite 7.1.12          - Frontend build tool
```

### Additional Packages

```
Laravel Breeze 2.3.8        - Authentication scaffolding (Livewire stack)
Spatie Permission 6.22.0     - Role & Permission management
Intervention Image 3.11.4    - Image manipulation
PHP 8.3.18                   - PHP version
```

---

## Quick Start

### 1. Create Database
```bash
mysql -u root -e "CREATE DATABASE IF NOT EXISTS trueid CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
```

### 2. Run Migrations (When Ready)
```bash
php artisan migrate
```

### 3. Create Storage Symlink
```bash
php artisan storage:link
```

### 4. Start Development
```bash
# Option 1: Laravel server
php artisan serve

# Option 2: Use Laragon
# Access: http://trueid.test
```

### 5. Frontend Development
```bash
# Watch for changes
npm run dev

# Build for production
npm run build
```

---

## Current Configuration

The project is pre-configured with:

**Database (.env):**
- Connection: MySQL
- Database: trueid
- Host: 127.0.0.1
- Port: 3306

**Email (.env):**
- Mailer: SMTP (Sendinblue)
- Host: smtp-relay.sendinblue.com
- Port: 587
- From: gengbizmail@gmail.com

---

## Next Steps

### Immediate Tasks

1. **Review Documentation**
   - Read: `C:\laragon\www\holobit\DOCUMENTATION.md`
   - Study database schema and relationships

2. **Create Database Migrations**
   ```bash
   php artisan make:migration create_codes_table
   php artisan make:migration create_products_table
   php artisan make:migration create_sellers_table
   php artisan make:migration create_customers_table
   ```

3. **Create Eloquent Models**
   ```bash
   php artisan make:model Code -mfs
   php artisan make:model Product -mfs
   php artisan make:model Seller -mfs
   php artisan make:model Customer -mfs
   ```

4. **Set Up Spatie Permission**
   ```bash
   php artisan vendor:publish --provider="Spatie\Permission\PermissionServiceProvider"
   php artisan migrate
   ```

5. **Create First Livewire Component**
   ```bash
   php artisan make:livewire Public/CodeVerification
   ```

---

## Development Roadmap

### Phase 1: Foundation (Week 1)
- [x] Laravel 12 project setup
- [x] TALL stack installation
- [x] Authentication setup (Breeze)
- [ ] Database migrations
- [ ] Eloquent models with relationships
- [ ] Admin layout

### Phase 2: Core Features (Week 2)
- [ ] Code verification (public)
- [ ] Code generation (admin)
- [ ] Product management
- [ ] Customer forms
- [ ] Lucky draw functionality

### Phase 3: Distribution (Week 3)
- [ ] Reseller/Agent CRUD
- [ ] Code assignment system
- [ ] Manager role
- [ ] Bulk operations
- [ ] Customer database

### Phase 4: Polish (Week 4)
- [ ] System setup page
- [ ] Custom field management
- [ ] Excel exports
- [ ] Email integration
- [ ] Testing & deployment

---

## Useful Commands

### Laravel Artisan
```bash
php artisan migrate              # Run migrations
php artisan make:livewire Name   # Create Livewire component
php artisan make:model Model -mfs # Model + migration + factory + seeder
php artisan route:list           # List all routes
php artisan optimize:clear       # Clear all caches
```

### Composer
```bash
composer install        # Install dependencies
composer require pkg    # Add package
composer dump-autoload  # Regenerate autoload
```

### NPM
```bash
npm install        # Install dependencies
npm run dev        # Development mode
npm run build      # Production build
```

---

## Resources

- [Laravel 12 Docs](https://laravel.com/docs/12.x)
- [Livewire 3 Docs](https://livewire.laravel.com/docs)
- [Tailwind CSS Docs](https://tailwindcss.com/docs)
- [Alpine.js Docs](https://alpinejs.dev)
- [Spatie Permission](https://spatie.be/docs/laravel-permission)

**Original Project Documentation:**
`C:\laragon\www\holobit\DOCUMENTATION.md`

---

## License

Proprietary - Gengbiz Hologram Security Sticker System
