<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance Report - <?php echo e($staffName); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        @page {
            size: A4;
            margin: 0.5in 0.75in;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
        }

        .container {
            width: 100%;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Top 75% - Performance Data */
        .performance-section {
            flex: 0 0 75%;
            padding-bottom: 12px;
            border-bottom: 2px solid #000;
        }

        .header {
            text-align: center;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 1px solid #333;
        }

        .header h1 {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 4px;
        }

        .header h2 {
            font-size: 13pt;
            color: #333;
        }

        .staff-info {
            margin-bottom: 12px;
            background: #f5f5f5;
            padding: 8px 10px;
            border-left: 3px solid #4F46E5;
        }

        .staff-info h3 {
            font-size: 13pt;
            margin-bottom: 4px;
        }

        .period {
            font-size: 10pt;
            color: #666;
        }

        .summary-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 8px;
            margin-bottom: 12px;
        }

        .summary-card {
            border: 1px solid #ddd;
            padding: 6px 8px;
            text-align: center;
        }

        .summary-card .label {
            font-size: 9pt;
            color: #666;
            margin-bottom: 3px;
        }

        .summary-card .value {
            font-size: 15pt;
            font-weight: bold;
            color: #4F46E5;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            font-size: 10pt;
        }

        table th,
        table td {
            border: 1px solid #ddd;
            padding: 4px 8px;
            text-align: left;
        }

        table th {
            background: #f0f0f0;
            font-weight: bold;
        }

        table tbody tr:nth-child(even) {
            background: #fafafa;
        }

        /* Bottom 25% - Notes & Signatures */
        .notes-section {
            flex: 0 0 25%;
            display: flex;
            flex-direction: column;
            padding-top: 10px;
        }

        .notes-header {
            font-size: 11pt;
            font-weight: bold;
            margin-bottom: 8px;
        }

        .notes-area {
            flex: 1;
            border: 1px solid #333;
            padding: 6px;
            min-height: 80px;
        }

        .signature-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
            margin-top: 12px;
        }

        .signature-field {
            border-top: 1px solid #000;
            padding-top: 5px;
        }

        .signature-label {
            font-size: 8pt;
            color: #666;
        }

        .prepared-info {
            margin-top: 8px;
            font-size: 8pt;
            color: #666;
        }

        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }

            .container {
                page-break-inside: avoid;
            }

            button {
                display: none;
            }
        }

        .no-print {
            display: block;
            text-align: center;
            margin: 20px 0;
        }

        @media print {
            .no-print {
                display: none;
            }
        }

        .print-button {
            background: #4F46E5;
            color: white;
            border: none;
            padding: 12px 24px;
            font-size: 11pt;
            border-radius: 5px;
            cursor: pointer;
        }

        .print-button:hover {
            background: #4338CA;
        }
    </style>
</head>
<body>
    <!-- Print Button (hidden when printing) -->
    <div class="no-print">
        <button onclick="window.print()" class="print-button">🖨️ Print Report</button>
    </div>

    <div class="container">
        <!-- Top Section: Performance Data (65%) -->
        <div class="performance-section">
            <!-- Header -->
            <div class="header">
                <h1>OmniaBoss Production</h1>
                <h2>Staff Performance Report</h2>
            </div>

            <!-- Staff Info -->
            <div class="staff-info">
                <h3><?php echo e($staffName); ?></h3>
                <div class="period">
                    Performance Period: <?php echo e(\Carbon\Carbon::parse($dateFrom)->format('d M Y')); ?> - <?php echo e(\Carbon\Carbon::parse($dateTo)->format('d M Y')); ?>

                    (<?php echo e($dayCount); ?> days)
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="summary-grid">
                <div class="summary-card">
                    <div class="label">Orders Packed</div>
                    <div class="value"><?php echo e(number_format($totalPacked)); ?></div>
                </div>
                <div class="summary-card">
                    <div class="label">Orders Completed</div>
                    <div class="value"><?php echo e(number_format($totalCompleted)); ?></div>
                </div>
                <div class="summary-card">
                    <div class="label">Total Orders</div>
                    <div class="value"><?php echo e(number_format($totalOrders)); ?></div>
                </div>
                <div class="summary-card">
                    <div class="label">Daily Average</div>
                    <div class="value"><?php echo e($dailyAverage); ?></div>
                </div>
            </div>

            <!-- Daily Breakdown Table - Split into 2 columns -->
            <?php if($dailyBreakdown->count() > 0): ?>
                <?php
                    $halfCount = 16; // First 16 days in left column
                    $leftDays = $dailyBreakdown->take($halfCount);
                    $rightDays = $dailyBreakdown->skip($halfCount);
                ?>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <!-- Left Table: Days 1-16 -->
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th style="text-align: center;">Orders</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $leftDays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($day['date'])->format('d M Y')); ?></td>
                                    <td style="text-align: center;"><?php echo e($day['packed'] + $day['completed']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($leftDays->count() < $halfCount): ?>
                                <?php for($i = $leftDays->count(); $i < $halfCount; $i++): ?>
                                    <tr><td colspan="2" style="border: none;">&nbsp;</td></tr>
                                <?php endfor; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <!-- Right Table: Days 17-31 -->
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th style="text-align: center;">Orders</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $rightDays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($day['date'])->format('d M Y')); ?></td>
                                    <td style="text-align: center;"><?php echo e($day['packed'] + $day['completed']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

        <!-- Bottom Section: Manager Notes & Signatures (35%) -->
        <div class="notes-section">
            <div class="notes-header">Manager's Notes / Comments:</div>
            <div class="notes-area">
                <!-- Blank space for handwritten notes -->
            </div>

            <!-- Signature Fields -->
            <div class="signature-row">
                <div>
                    <div class="signature-field">
                        <div class="signature-label">Manager Signature & Date</div>
                    </div>
                </div>
                <div>
                    <div class="signature-field">
                        <div class="signature-label">Staff Acknowledgment & Date</div>
                    </div>
                </div>
            </div>

            <!-- Prepared Info -->
            <div class="prepared-info">
                Report prepared by: <?php echo e($preparedBy); ?> | Date: <?php echo e(\Carbon\Carbon::parse($preparedDate)->format('d M Y')); ?>

            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\omniaboss\services\production\resources\views/performance/print.blade.php ENDPATH**/ ?>