<?php

use App\Http\Controllers\OrderController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\InventoryController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

// SSO-Protected Routes
Route::middleware('omnia.sso')->group(function () {
    // Dashboard & Performance
    Route::get('/dashboard', [OrderController::class, 'index'])->name('dashboard');
    Route::get('/performance', [OrderController::class, 'performance'])->name('performance');
    Route::get('/performance/print/{staffId}', [OrderController::class, 'printStaffReport'])->name('performance.print');

    // Order Operations
    Route::post('/orders/scan', [OrderController::class, 'scanTrackingNumber'])->name('orders.scan');
    Route::post('/orders/{id}/pack', [OrderController::class, 'markAsPacked'])->name('orders.pack');
    Route::post('/orders/{id}/complete', [OrderController::class, 'markAsCompleted'])->name('orders.complete');
    Route::post('/orders/bulk-complete', [OrderController::class, 'bulkComplete'])->name('orders.bulk-complete');
    Route::post('/orders/{id}/undo-packed', [OrderController::class, 'undoPacked'])->name('orders.undo-packed');
    Route::get('/api/orders/pending-count', [OrderController::class, 'getPendingCount'])->name('api.orders.pending-count');

    // Suppliers
    Route::resource('suppliers', SupplierController::class);

    // Purchase Orders
    Route::prefix('purchase-orders')->name('purchase-orders.')->group(function () {
        Route::get('/', [PurchaseOrderController::class, 'index'])->name('index');
        Route::get('/create', [PurchaseOrderController::class, 'create'])->name('create');
        Route::post('/', [PurchaseOrderController::class, 'store'])->name('store');
        Route::get('/{id}', [PurchaseOrderController::class, 'show'])->name('show');
        Route::get('/{id}/print', [PurchaseOrderController::class, 'print'])->name('print');
        Route::get('/{id}/edit', [PurchaseOrderController::class, 'edit'])->name('edit');
        Route::put('/{id}', [PurchaseOrderController::class, 'update'])->name('update');
        Route::post('/{id}/confirm', [PurchaseOrderController::class, 'confirm'])->name('confirm');
        Route::post('/{id}/cancel', [PurchaseOrderController::class, 'cancel'])->name('cancel');
        Route::get('/{id}/receive', [PurchaseOrderController::class, 'receive'])->name('receive');
        Route::post('/{id}/receive', [PurchaseOrderController::class, 'processReceive'])->name('process-receive');
    });

    // Inventory
    Route::prefix('inventory')->name('inventory.')->group(function () {
        Route::get('/', [InventoryController::class, 'index'])->name('index');
        Route::get('/movements', [InventoryController::class, 'movements'])->name('movements');
        Route::get('/low-stock', [InventoryController::class, 'lowStock'])->name('low-stock');
        Route::get('/adjust', [InventoryController::class, 'adjust'])->name('adjust');
        Route::post('/adjust', [InventoryController::class, 'processAdjustment'])->name('process-adjust');
        Route::post('/sync', [InventoryController::class, 'syncFromMarketing'])->name('sync');
        Route::get('/{sku}', [InventoryController::class, 'show'])->name('show');
    });
});
